/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.mule.util.Preconditions;

public final class CollectionValueResolver<T>
implements ValueResolver<Collection<T>> {
    private final List<ValueResolver<T>> resolvers;
    private final Class<? extends Collection> collectionType;

    public static <T> CollectionValueResolver<T> of(Class<? extends Collection> collectionType, List<ValueResolver<T>> resolvers) {
        if (List.class.equals(collectionType) || Collection.class.equals(collectionType) || Iterable.class.equals(collectionType)) {
            return new CollectionValueResolver<T>(ArrayList.class, resolvers);
        }
        if (Set.class.equals(collectionType)) {
            return new CollectionValueResolver<T>(HashSet.class, resolvers);
        }
        return new CollectionValueResolver<T>(collectionType, resolvers);
    }

    public CollectionValueResolver(Class<? extends Collection> collectionType, List<ValueResolver<T>> resolvers) {
        IntrospectionUtils.checkInstantiable(collectionType);
        Preconditions.checkArgument((resolvers != null ? 1 : 0) != 0, (String)"resolvers cannot be null");
        this.collectionType = collectionType;
        this.resolvers = ImmutableList.copyOf(resolvers);
    }

    @Override
    public Collection<T> resolve(MuleEvent event) throws MuleException {
        Collection<T> collection = this.instantiateCollection();
        for (ValueResolver<T> resolver : this.resolvers) {
            collection.add(resolver.resolve(event));
        }
        return collection;
    }

    @Override
    public boolean isDynamic() {
        return MuleExtensionUtils.hasAnyDynamic(this.resolvers);
    }

    private Collection<T> instantiateCollection() {
        try {
            return this.collectionType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create instance of " + this.collectionType.getName(), e);
        }
    }
}

