/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import java.io.IOException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.TlsDirectKeyStore;
import org.mule.api.security.TlsDirectTrustStore;
import org.mule.api.security.TlsIndirectKeyStore;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.transport.servlet.jetty.JettyHttpConnector;

public class JettyHttpsConnector
extends JettyHttpConnector
implements TlsDirectKeyStore,
TlsIndirectKeyStore,
TlsDirectTrustStore {
    public static final String JETTY_SSL = "jetty-ssl";
    public static final String HTTPS = "https";
    public static final String PEER_CERTIFICATES = "PEER_CERTIFICATES";
    public static final String LOCAL_CERTIFICATES = "LOCAL_CERTIFICATES";
    private TlsConfiguration tls = new TlsConfiguration(".keystore");

    public JettyHttpsConnector(MuleContext context) {
        super(context);
        this.registerSupportedProtocol(HTTPS);
        this.registerSupportedProtocol(JETTY_SSL);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.validateSslConfig();
        super.doInitialise();
    }

    protected void validateSslConfig() throws InitialisationException {
        try {
            this.tls.initialise(false, "javax.net");
        }
        catch (CreateException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public String getProtocol() {
        return JETTY_SSL;
    }

    public String getClientKeyStore() {
        return this.tls.getClientKeyStore();
    }

    public String getClientKeyStorePassword() {
        return this.tls.getClientKeyStorePassword();
    }

    public String getClientKeyStoreType() {
        return this.tls.getClientKeyStoreType();
    }

    public String getKeyManagerAlgorithm() {
        return this.tls.getKeyManagerAlgorithm();
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.tls.getKeyManagerFactory();
    }

    public String getKeyPassword() {
        return this.tls.getKeyPassword();
    }

    public String getKeyAlias() {
        return this.tls.getKeyAlias();
    }

    public String getKeyStore() {
        return this.tls.getKeyStore();
    }

    public String getKeyStoreType() {
        return this.tls.getKeyStoreType();
    }

    public String getSslType() {
        return this.tls.getSslType();
    }

    public String getKeyStorePassword() {
        return this.tls.getKeyStorePassword();
    }

    public String getTrustManagerAlgorithm() {
        return this.tls.getTrustManagerAlgorithm();
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.tls.getTrustManagerFactory();
    }

    public String getTrustStore() {
        return this.tls.getTrustStore();
    }

    public String getTrustStorePassword() {
        return this.tls.getTrustStorePassword();
    }

    public String getTrustStoreType() {
        return this.tls.getTrustStoreType();
    }

    public boolean isExplicitTrustStoreOnly() {
        return this.tls.isExplicitTrustStoreOnly();
    }

    public boolean isRequireClientAuthentication() {
        return this.tls.isRequireClientAuthentication();
    }

    public void setClientKeyStore(String clientKeyStore) throws IOException {
        this.tls.setClientKeyStore(clientKeyStore);
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.tls.setClientKeyStorePassword(clientKeyStorePassword);
    }

    public void setClientKeyStoreType(String clientKeyStoreType) {
        this.tls.setClientKeyStoreType(clientKeyStoreType);
    }

    public void setExplicitTrustStoreOnly(boolean explicitTrustStoreOnly) {
        this.tls.setExplicitTrustStoreOnly(explicitTrustStoreOnly);
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.tls.setKeyManagerAlgorithm(keyManagerAlgorithm);
    }

    public void setKeyPassword(String keyPassword) {
        this.tls.setKeyPassword(keyPassword);
    }

    public void setKeyAlias(String alias) {
        this.tls.setKeyAlias(alias);
    }

    public void setKeyStore(String keyStore) throws IOException {
        this.tls.setKeyStore(keyStore);
    }

    public void setKeyStoreType(String keystoreType) {
        this.tls.setKeyStoreType(keystoreType);
    }

    public void setRequireClientAuthentication(boolean requireClientAuthentication) {
        this.tls.setRequireClientAuthentication(requireClientAuthentication);
    }

    public void setSslType(String sslType) {
        this.tls.setSslType(sslType);
    }

    public void setKeyStorePassword(String storePassword) {
        this.tls.setKeyStorePassword(storePassword);
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.tls.setTrustManagerAlgorithm(trustManagerAlgorithm);
    }

    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.tls.setTrustManagerFactory(trustManagerFactory);
    }

    public void setTrustStore(String trustStore) throws IOException {
        this.tls.setTrustStore(trustStore);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.tls.setTrustStorePassword(trustStorePassword);
    }

    public void setTrustStoreType(String trustStoreType) {
        this.tls.setTrustStoreType(trustStoreType);
    }

    @Override
    protected AbstractNetworkConnector createJettyConnector() {
        SslContextFactory sslContextFactory = this.createSslContextFactory();
        return new ServerConnector(this.getHttpServer(), this.getAcceptors(), this.getSelectors(), sslContextFactory);
    }

    private SslContextFactory createSslContextFactory() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setProtocol(this.getSslType());
        if (this.tls.getKeyStore() != null) {
            sslContextFactory.setKeyStorePath(this.tls.getKeyStore());
        }
        if (this.tls.getKeyStorePassword() != null) {
            sslContextFactory.setKeyStorePassword(this.tls.getKeyStorePassword());
        }
        if (this.tls.getKeyPassword() != null) {
            sslContextFactory.setKeyManagerPassword(this.tls.getKeyPassword());
        }
        if (this.tls.getKeyStoreType() != null) {
            sslContextFactory.setKeyStoreType(this.tls.getKeyStoreType());
        }
        if (this.tls.getKeyManagerAlgorithm() != null) {
            sslContextFactory.setSslKeyManagerFactoryAlgorithm(this.tls.getKeyManagerAlgorithm());
        }
        if (this.tls.getTrustStorePassword() != null) {
            sslContextFactory.setTrustStorePassword(this.tls.getTrustStorePassword());
        }
        if (this.tls.getTrustStore() != null) {
            sslContextFactory.setTrustStorePath(this.tls.getTrustStore());
        }
        if (this.tls.getTrustStoreType() != null) {
            sslContextFactory.setTrustStoreType(this.tls.getTrustStoreType());
        }
        if (this.tls.getTrustManagerAlgorithm() != null) {
            sslContextFactory.setSslKeyManagerFactoryAlgorithm(this.tls.getTrustManagerAlgorithm());
        }
        sslContextFactory.setNeedClientAuth(this.tls.isRequireClientAuthentication());
        if (this.tls.getEnabledCipherSuites() != null) {
            sslContextFactory.setIncludeCipherSuites(this.tls.getEnabledCipherSuites());
        }
        if (this.tls.getEnabledProtocols() != null) {
            sslContextFactory.setIncludeProtocols(this.tls.getEnabledProtocols());
        }
        return sslContextFactory;
    }
}

