/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.client.OperationOptions;
import org.mule.api.config.ConfigurationException;
import org.mule.api.connector.ConnectorOperationLocator;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.internal.config.HttpConfiguration;
import org.mule.module.ws.security.WSSecurity;
import org.mule.util.Preconditions;
import org.mule.util.StringUtils;

public class WSConsumerConfig
implements MuleContextAware {
    private MuleContext muleContext;
    private String name;
    private String wsdlLocation;
    private String service;
    private String port;
    private String serviceAddress;
    private boolean useConnectorToRetrieveWsdl;
    private Connector connector;
    private HttpRequesterConfig connectorConfig;
    private WSSecurity security;

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public MessageProcessor createOutboundMessageProcessor() throws MuleException {
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)this.serviceAddress), (String)"No serviceAddress provided in WS consumer config");
        if (this.connectorConfig != null && this.connector != null) {
            throw new ConfigurationException(CoreMessages.createStaticMessage((String)"Cannot set both connector-config and connector-ref attributes. Set either one of them, or none for default behavior."));
        }
        if (this.useHttpModule()) {
            return this.createHttpRequester();
        }
        return this.createOutboundEndpoint();
    }

    private boolean useHttpModule() {
        if (this.connectorConfig != null) {
            return true;
        }
        if (!this.isHttp()) {
            return false;
        }
        if (this.connector != null) {
            return false;
        }
        return !HttpConfiguration.useTransportForUris((MuleContext)this.muleContext);
    }

    private OutboundEndpoint createOutboundEndpoint() throws MuleException {
        EndpointBuilder builder = this.muleContext.getEndpointFactory().getEndpointBuilder(this.serviceAddress);
        if (this.connector != null) {
            String protocol = new MuleEndpointURI(this.serviceAddress, this.muleContext).getScheme();
            if (!this.connector.supportsProtocol(protocol)) {
                throw new IllegalStateException(String.format("Connector %s does not support protocol: %s", this.connector.getName(), protocol));
            }
            builder.setConnector(this.connector);
        }
        return this.muleContext.getEndpointFactory().getOutboundEndpoint(builder);
    }

    private MessageProcessor createHttpRequester() throws MuleException {
        return new MessageProcessor(){
            private HttpRequestOptions requestOptions;

            public MuleEvent process(MuleEvent event) throws MuleException {
                ConnectorOperationLocator connectorOperationLocator = (ConnectorOperationLocator)WSConsumerConfig.this.muleContext.getRegistry().get("_muleConnectorMessageProcessorLocator");
                MessageProcessor messageProcessor = connectorOperationLocator.locateConnectorOperation(WSConsumerConfig.this.serviceAddress, (OperationOptions)this.getRequestOptions(), MessageExchangePattern.REQUEST_RESPONSE);
                return messageProcessor.process(event);
            }

            private HttpRequestOptions getRequestOptions() {
                if (this.requestOptions == null) {
                    HttpRequestOptionsBuilder builder = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().disableParseResponse();
                    if (WSConsumerConfig.this.connectorConfig != null) {
                        builder.requestConfig(WSConsumerConfig.this.connectorConfig);
                    }
                    this.requestOptions = builder.build();
                }
                return this.requestOptions;
            }
        };
    }

    private boolean isHttp() {
        return this.serviceAddress.startsWith("http");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public HttpRequesterConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public void setConnectorConfig(HttpRequesterConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public WSSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(WSSecurity security) {
        this.security = security;
    }

    public boolean isUseConnectorToRetrieveWsdl() {
        return this.useConnectorToRetrieveWsdl;
    }

    public void setUseConnectorToRetrieveWsdl(boolean useConnectorToRetrieveWsdl) {
        this.useConnectorToRetrieveWsdl = useConnectorToRetrieveWsdl;
    }
}

