/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.packet.Message;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.xmpp.XmppConnector;
import org.mule.transport.xmpp.XmppConversation;

public class XmppMessageDispatcher
extends AbstractMessageDispatcher {
    private final XmppConnector xmppConnector;
    private XmppConversation conversation;

    public XmppMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.xmppConnector = (XmppConnector)endpoint.getConnector();
        this.conversation = this.xmppConnector.getConversationFactory().create((ImmutableEndpoint)endpoint);
    }

    protected void doConnect() throws Exception {
        this.conversation.connect(false);
    }

    protected void doDisconnect() throws Exception {
        this.conversation.disconnect();
    }

    protected void doDispose() {
        this.conversation = null;
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        this.sendMessage(event);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.sendMessage(event);
        return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.getEndpoint().getMuleContext());
    }

    protected void sendMessage(MuleEvent event) throws Exception {
        if (!this.xmppConnector.getXmppConnection().isConnected()) {
            this.xmppConnector.getXmppConnection().connect();
        }
        Message jabberMessage = (Message)event.getMessage().getPayload(DataTypeFactory.create(Message.class));
        this.conversation.dispatch(jabberMessage);
        if (this.logger.isDebugEnabled()) {
            String recipient = XmppConnector.getRecipient(this.endpoint);
            this.logger.debug((Object)("Message \"" + jabberMessage.getBody() + "\" successfully sent to " + recipient));
        }
    }
}

