/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.sftp.SftpConnector;
import org.mule.transport.sftp.SftpReceiverRequesterUtil;
import org.mule.transport.sftp.SftpStream;
import org.mule.transport.sftp.notification.SftpNotifier;

public class SftpMessageRequester
extends AbstractMessageRequester {
    private SftpReceiverRequesterUtil sftpRRUtil = null;

    public SftpMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.sftpRRUtil = new SftpReceiverRequesterUtil((ImmutableEndpoint)endpoint);
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        String[] files = this.sftpRRUtil.getAvailableFiles(true);
        if (files.length == 0) {
            return null;
        }
        String path = files[0];
        SftpNotifier notifier = new SftpNotifier((SftpConnector)this.connector, this.createNullMuleMessage(), this.endpoint, this.endpoint.getName());
        SftpStream sftpStream = (SftpStream)((Object)this.sftpRRUtil.retrieveFile(path, notifier));
        if (sftpStream != null) {
            sftpStream.performPostProcessingOnClose(true);
        }
        this.logger.debug((Object)("Routing file: " + path));
        MuleMessage message = this.createMuleMessage(sftpStream);
        message.setProperty("originalFilename", (Object)path, PropertyScope.INBOUND);
        notifier.setMessage(message);
        return message;
    }
}

