/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.mule.api.CompletionHandler;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transaction.Transaction;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsMessageUtils;
import org.mule.transport.jms.i18n.JmsMessages;
import org.mule.util.concurrent.Latch;
import org.mule.util.concurrent.WaitableBoolean;

public class JmsMessageDispatcher
extends AbstractMessageDispatcher {
    private JmsConnector connector;
    private boolean disableTemporaryDestinations = false;
    private boolean returnOriginalMessageAsReply = false;

    public JmsMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (JmsConnector)endpoint.getConnector();
        this.disableTemporaryDestinations = this.connector.isDisableTemporaryReplyToDestinations() || "true".equals(endpoint.getProperty((Object)"disableTemporaryReplyToDestinations"));
        boolean bl = this.returnOriginalMessageAsReply = this.connector.isReturnOriginalMessageAsReply() || "true".equals(endpoint.getProperty((Object)"returnOriginalMessageAsReply"));
        if (this.returnOriginalMessageAsReply && !this.disableTemporaryDestinations) {
            this.logger.warn((Object)"The returnOriginalMessageAsReply property will be ignored because disableTemporaryReplyToDestinations=false.  You need to disable temporary ReplyTo destinations in order for this propery to take effect.");
        }
        this.logger.warn((Object)"Starting patched JmsMessageReceiver");
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        if (this.connector.getConnection() == null) {
            throw new IllegalStateException("No JMS Connection");
        }
        this.dispatchMessage(event, false, null);
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected boolean isDisableTemporaryDestinations() {
        return this.disableTemporaryDestinations;
    }

    protected long getTimeToLive(MuleMessage message) {
        return (Long)message.getOutboundProperty("timeToLive", (Object)0L);
    }

    protected int getPriority(MuleMessage message) {
        return (Integer)message.getOutboundProperty("priority", (Object)4);
    }

    protected boolean getPersistentDelivery(MuleMessage message) {
        return (Boolean)message.getOutboundProperty("persistentDelivery", (Object)this.connector.isPersistentDelivery());
    }

    /*
     * Exception decompiling
     */
    private MuleMessage dispatchMessage(MuleEvent event, boolean doSend, CompletionHandler<MuleMessage, Exception> completionHandler) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MuleMessage internalSend(MessageProducer producer, Message jmsMessage, boolean topic, long ttl, int priority, boolean persistent) throws Exception {
        this.connector.getJmsSupport().send(producer, jmsMessage, persistent, priority, ttl, topic, this.endpoint);
        return this.returnOriginalMessageAsReply ? this.createMuleMessage(jmsMessage) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MuleMessage internalBlockingSendAndAwait(Session session, MessageProducer producer, Destination replyTo, Message jmsMessage, boolean topic, long ttl, int priority, boolean persistent, int timeout, MuleEvent event) throws Exception {
        this.connector.getJmsSupport().send(producer, jmsMessage, persistent, priority, ttl, topic, this.endpoint);
        MessageConsumer consumer = this.createReplyToConsumer(jmsMessage, event, session, replyTo, topic);
        try {
            Latch latch = new Latch();
            LatchReplyToListener listener = new LatchReplyToListener(latch);
            consumer.setMessageListener((MessageListener)listener);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Waiting for response event for: " + timeout + " ms on " + replyTo));
            }
            latch.await((long)timeout, TimeUnit.MILLISECONDS);
            consumer.setMessageListener(null);
            listener.release();
            MuleMessage muleMessage = this.createResponseMuleMessage(listener.getMessage(), replyTo);
            return muleMessage;
        }
        finally {
            this.closeConsumer(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MuleMessage internalBlockingSendAndReceive(Session session, MessageProducer producer, Destination replyTo, Message jmsMessage, boolean topic, long ttl, int priority, boolean persistent, int timeout, MuleEvent event) throws Exception {
        this.connector.getJmsSupport().send(producer, jmsMessage, persistent, priority, ttl, topic, this.endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Waiting for non-blocking response event for: " + timeout + " ms on " + replyTo));
        }
        MessageConsumer consumer = this.createReplyToConsumer(jmsMessage, event, session, replyTo, topic);
        try {
            Message result = consumer.receive((long)timeout);
            MuleMessage muleMessage = this.createResponseMuleMessage(result, replyTo);
            return muleMessage;
        }
        finally {
            this.closeConsumer(consumer);
        }
    }

    private void internalNonBlockingSendAndReceive(final Session session, final MessageProducer producer, final Destination replyTo, Message jmsMessage, boolean topic, long ttl, int priority, boolean persistent, boolean transacted, int timeout, final CompletionHandler<MuleMessage, Exception> completionHandler, MuleEvent event) throws JMSException {
        this.connector.getJmsSupport().send(producer, jmsMessage, persistent, priority, ttl, topic, this.endpoint);
        final MessageConsumer consumer = this.createReplyToConsumer(jmsMessage, event, session, replyTo, topic);
        final TimerTask closeConsumerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    completionHandler.onCompletion((Object)JmsMessageDispatcher.this.createMuleMessage(null));
                }
                catch (MuleException e) {
                    completionHandler.onFailure((Throwable)e);
                }
                finally {
                    JmsMessageDispatcher.this.cleanup(producer, session, consumer, replyTo);
                }
            }
        };
        this.connector.scheduleTimeoutTask(closeConsumerTask, this.endpoint.getResponseTimeout());
        consumer.setMessageListener((MessageListener)new CompletionHandlerReplyToListener(new CompletionHandler<Message, Exception>(){

            public void onCompletion(Message result) {
                try {
                    closeConsumerTask.cancel();
                    completionHandler.onCompletion((Object)JmsMessageDispatcher.this.createResponseMuleMessage(result, replyTo));
                }
                catch (Exception e) {
                    completionHandler.onFailure((Throwable)e);
                }
                finally {
                    JmsMessageDispatcher.this.cleanup(producer, session, consumer, replyTo);
                }
            }

            public void onFailure(Exception exception) {
                try {
                    completionHandler.onFailure((Throwable)exception);
                }
                finally {
                    JmsMessageDispatcher.this.cleanup(producer, session, consumer, replyTo);
                }
            }
        }));
    }

    private void cleanup(MessageProducer producer, Session session, MessageConsumer consumer, Destination replyTo) {
        this.closeProducer(producer);
        this.closeConsumer(consumer);
        this.closeReplyQueue(session, replyTo);
        this.closeSession(session);
    }

    private MessageProducer createProducer(Session session, boolean topic) throws JMSException {
        Destination dest = this.connector.getJmsSupport().createDestination(session, this.endpoint);
        return this.connector.getJmsSupport().createProducer(session, dest, topic);
    }

    private Message getJmsMessagePayload(MuleEvent event) throws DispatchException {
        Object message = event.getMessage().getPayload();
        if (!(message instanceof Message)) {
            throw new DispatchException(JmsMessages.checkTransformer("JMS message", message.getClass(), this.connector.getName()), event, (MessageProcessor)this.getEndpoint());
        }
        return (Message)message;
    }

    private boolean isUseReplyToDestination(MuleEvent event, boolean doSend, boolean transacted) {
        return this.returnResponse(event, doSend) && !transacted;
    }

    private boolean isTransacted() {
        Transaction muleTx = TransactionCoordination.getInstance().getTransaction();
        return muleTx != null && muleTx.hasResource((Object)this.connector.getConnection()) || this.endpoint.getTransactionConfig().isTransacted();
    }

    private void closeReplyQueue(Session session, Destination replyTo) {
        if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
            if (replyTo instanceof TemporaryQueue) {
                this.connector.closeQuietly((TemporaryQueue)replyTo);
            } else {
                this.connector.closeQuietly((TemporaryTopic)replyTo);
            }
        }
    }

    private void closeConsumer(MessageConsumer consumer) {
        this.connector.closeQuietly(consumer);
    }

    private void closeProducer(MessageProducer producer) {
        this.connector.closeQuietly(producer);
    }

    private void closeSession(Session session) {
        if (session != null && !this.isTransacted()) {
            this.connector.closeQuietly(session);
        }
    }

    private MuleMessage createResponseMuleMessage(Message result, Destination replyTo) throws Exception {
        if (result == null) {
            this.logger.debug((Object)("No message was returned via replyTo destination " + replyTo));
            return this.createNullMuleMessage();
        }
        return this.createMessageWithJmsMessagePayload(result);
    }

    protected String resolveJmsCorrelationId(MuleEvent event) throws JMSException {
        return this.resolveMuleCorrelationId(event);
    }

    private String resolveMuleCorrelationId(MuleEvent event) throws JMSException {
        if (event.getFlowConstruct() != null && event.getFlowConstruct().getMessageInfoMapping() != null) {
            return event.getFlowConstruct().getMessageInfoMapping().getCorrelationId(event.getMessage());
        }
        return this.defaultMessageInfoMapping.getCorrelationId(event.getMessage());
    }

    protected MuleMessage createMessageWithJmsMessagePayload(Message jmsMessage) throws Exception {
        MuleMessage muleMessage = this.createMuleMessage(jmsMessage);
        Object payload = JmsMessageUtils.toObject(jmsMessage, this.connector.getSpecification(), this.endpoint.getEncoding());
        muleMessage.setPayload(payload);
        return muleMessage;
    }

    protected void preTransformMessage(MuleMessage message) throws Exception {
    }

    @Deprecated
    protected void handleMultiTx(Session session) throws Exception {
        this.logger.debug((Object)"Multi-transaction support is not available in Mule Community Edition.");
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        return this.dispatchMessage(event, true, null);
    }

    protected void doSendNonBlocking(MuleEvent event, CompletionHandler<MuleMessage, Exception> completionHandler) {
        try {
            this.dispatchMessage(event, true, completionHandler);
        }
        catch (Exception e) {
            completionHandler.onFailure((Throwable)e);
        }
    }

    protected void doDispose() {
    }

    protected void processMessage(Message msg, MuleEvent event) throws JMSException {
    }

    protected boolean isHandleReplyTo(Message msg, MuleEvent event) throws JMSException {
        return this.connector.supportsProperty("JMSReplyTo");
    }

    protected MessageConsumer createReplyToConsumer(Message jmsMessage, MuleEvent event, Session session, Destination replyTo, boolean topic) throws JMSException {
        String selector = null;
        if (!(replyTo instanceof TemporaryQueue) && !(replyTo instanceof TemporaryTopic)) {
            String jmsCorrelationId = this.encodeVendorSpecificID(jmsMessage.getJMSCorrelationID());
            if (jmsCorrelationId == null) {
                jmsCorrelationId = jmsMessage.getJMSMessageID();
            }
            selector = "JMSCorrelationID='" + jmsCorrelationId + "'";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("ReplyTo Selector is: " + selector));
            }
        }
        if (topic) {
            String durableName;
            String tempDurable = (String)event.getMessage().getInvocationProperty("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)event.getMessage().getInvocationProperty("durableName")) == null && durable && topic) {
                durableName = "mule." + this.connector.getName() + "." + event.getMessageSourceURI();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
                }
            }
        }
        return this.connector.getJmsSupport().createConsumer(session, replyTo, selector, this.connector.isNoLocal(), null, topic, this.endpoint);
    }

    protected String encodeVendorSpecificID(String jmsCorrelationID) {
        return jmsCorrelationID;
    }

    protected Destination getReplyToDestination(Message message, Session session, MuleEvent event, boolean remoteSync, boolean topic) throws JMSException, EndpointException, InitialisationException {
        Destination replyTo = null;
        if (this.isHandleReplyTo(message, event)) {
            Object tempReplyTo = event.getMessage().getOutboundProperty("JMSReplyTo");
            if (tempReplyTo == null && (tempReplyTo = event.getMessage().getOutboundProperty("MULE_REPLYTO")) != null) {
                int i = tempReplyTo.toString().indexOf("://");
                if (i > -1) {
                    tempReplyTo = tempReplyTo.toString().substring(i + 3);
                } else {
                    EndpointBuilder epb = event.getMuleContext().getRegistry().lookupEndpointBuilder(tempReplyTo.toString());
                    if (epb != null) {
                        tempReplyTo = epb.buildOutboundEndpoint().getEndpointURI().getAddress();
                    }
                }
            }
            if (tempReplyTo != null) {
                if (tempReplyTo instanceof Destination) {
                    replyTo = (Destination)tempReplyTo;
                } else {
                    boolean replyToTopic = false;
                    String reply = tempReplyTo.toString();
                    int i = reply.indexOf(":");
                    if (i > -1) {
                        String qtype = reply.substring(0, i);
                        replyToTopic = "topic".equalsIgnoreCase(qtype);
                        reply = reply.substring(i + 1);
                    }
                    replyTo = this.connector.getJmsSupport().createDestination(session, reply, replyToTopic, this.endpoint);
                }
            }
            if (remoteSync && replyTo == null && !this.disableTemporaryDestinations) {
                replyTo = this.connector.getJmsSupport().createTemporaryDestination(session, topic);
            }
        }
        return replyTo;
    }

    protected void applyOutboundTransformers(MuleEvent event) throws MuleException {
        try {
            this.preTransformMessage(event.getMessage());
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.failedToInvoke((String)"preTransformMessage"), (Throwable)e);
        }
        super.applyOutboundTransformers(event);
    }

    protected boolean isSupportsNonBlocking() {
        return true;
    }

    protected String getCorrelationId(MuleEvent event) {
        return event.getMessage().getCorrelationId();
    }

    private class CompletionHandlerReplyToListener
    implements MessageListener {
        private final CompletionHandler completionHandler;

        public CompletionHandlerReplyToListener(CompletionHandler<Message, Exception> completionHandler) {
            this.completionHandler = completionHandler;
        }

        public void onMessage(Message message) {
            this.completionHandler.onCompletion((Object)message);
        }
    }

    protected class LatchReplyToListener
    implements MessageListener {
        private final Latch latch;
        private volatile Message message;
        private final WaitableBoolean released = new WaitableBoolean(false);

        public LatchReplyToListener(Latch latch) {
            this.latch = latch;
        }

        public Message getMessage() {
            return this.message;
        }

        public void release() {
            this.released.set(true);
        }

        public void onMessage(Message message) {
            this.message = message;
            this.latch.countDown();
            try {
                this.released.whenTrue(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

