/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax.container;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.Message;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.cometd.MessagePool;
import org.mortbay.cometd.continuation.ContinuationBayeux;
import org.mortbay.cometd.continuation.ContinuationCometdServlet;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.transport.Connector;
import org.mule.module.json.transformers.ObjectToJson;
import org.mule.transport.ajax.BayeuxAware;
import org.mule.transport.ajax.container.AjaxServletConnector;
import org.mule.transport.ajax.i18n.AjaxMessages;
import org.mule.transport.service.TransportFactory;
import org.mule.util.annotation.AnnotationUtils;

public class MuleAjaxServlet
extends ContinuationCometdServlet {
    protected Connector connector = null;
    private ObjectToJson jsonTransformer;
    private Set<Class<?>> ignoreClasses = new HashSet();
    private Set<Class<?>> jsonBindings = new HashSet();
    private MuleContext muleContext;

    public void init() throws ServletException {
        super.init();
        this.muleContext = (MuleContext)this.getServletContext().getAttribute("mule.context");
        if (this.muleContext == null) {
            throw new ServletException("Attribute mule.context not set on ServletContext");
        }
        String servletConnectorName = this.getServletConfig().getInitParameter("mule.connector.name");
        if (servletConnectorName == null) {
            servletConnectorName = (String)this.getServletContext().getAttribute("mule.connector.name");
        }
        if (servletConnectorName == null) {
            this.connector = new TransportFactory(this.muleContext).getConnectorByProtocol(this.getConnectorProtocol());
            if (this.connector == null) {
                this.connector = new AjaxServletConnector(this.muleContext);
                this.connector.setName("ajax.servlet." + this.getServletContext().getServerInfo());
                try {
                    this.muleContext.getRegistry().registerConnector(this.connector);
                }
                catch (MuleException e) {
                    throw new ServletException("Failed to register the AjaxServletConnector", (Throwable)e);
                }
            }
        } else {
            this.connector = this.muleContext.getRegistry().lookupConnector(servletConnectorName);
            if (this.connector == null) {
                throw new ServletException(AjaxMessages.noAjaxConnectorWithName(servletConnectorName, "mule.connector.name").toString());
            }
        }
        try {
            ((BayeuxAware)this.connector).setBayeux(this.getBayeux());
            this.jsonTransformer = new ObjectToJson();
            this.muleContext.getRegistry().applyProcessorsAndLifecycle((Object)this.jsonTransformer);
        }
        catch (MuleException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.service(request, response);
    }

    protected String getConnectorProtocol() {
        return "ajax-servlet";
    }

    protected AbstractBayeux newBayeux() {
        return new MuleContinuationBayeux();
    }

    public class MuleMessageImpl
    extends MessageImpl {
        public MuleMessageImpl(MessagePool bayeux) {
            super(bayeux);
        }

        public String getJSON() {
            Object data = this.getData();
            try {
                if (data != null && !MuleAjaxServlet.this.ignoreClasses.contains(data.getClass())) {
                    if (MuleAjaxServlet.this.jsonBindings.contains(data.getClass())) {
                        return (String)MuleAjaxServlet.this.jsonTransformer.transform((Object)this);
                    }
                    if (AnnotationUtils.hasAnnotationWithPackage((String)"org.codehaus.jackson", data.getClass())) {
                        MuleAjaxServlet.this.jsonBindings.add(data.getClass());
                        return (String)MuleAjaxServlet.this.jsonTransformer.transform((Object)this);
                    }
                    MuleAjaxServlet.this.ignoreClasses.add(data.getClass());
                }
                return super.getJSON();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to convert message to JSON", e);
            }
        }
    }

    protected class MuleContinuationBayeux
    extends ContinuationBayeux {
        protected MuleContinuationBayeux() {
        }

        public MessageImpl newMessage() {
            MuleMessageImpl message = new MuleMessageImpl((MessagePool)this);
            message.incRef();
            return message;
        }

        public MessageImpl newMessage(Message associated) {
            MuleMessageImpl message = new MuleMessageImpl((MessagePool)this);
            message.incRef();
            if (associated != null) {
                message.setAssociated(associated);
            }
            return message;
        }
    }
}

