/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.MessageExchangePattern;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.CompletionHandler;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.SecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.ReplyToHandler;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.SensingNullReplyToHandler;
import org.mule.tck.security.TestSecurityFilter;
import org.mule.tck.testmodels.mule.TestMessageDispatcher;
import org.mule.tck.testmodels.mule.TestMessageDispatcherFactory;
import org.mule.transformer.simple.OutboundAppendTransformer;
import org.mule.transformer.simple.ResponseAppendTransformer;
import org.mule.util.concurrent.Latch;

public class OutboundEndpointTestCase
extends AbstractMessageProcessorTestCase {
    protected FakeMessageDispatcher dispacher;
    protected MuleEvent testOutboundEvent;

    @Test
    public void testDefaultFlowSync() throws Exception {
        Transformer reqTransformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)reqTransformer.process((MuleEvent)Matchers.any(MuleEvent.class))).then(this.echoEventAnswer);
        Transformer resTransformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)resTransformer.process((MuleEvent)Matchers.any(MuleEvent.class))).then(this.echoEventAnswer);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, reqTransformer, resTransformer, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        ((Transformer)Mockito.verify((Object)reqTransformer, (VerificationMode)Mockito.times((int)1))).process((MuleEvent)Matchers.any(MuleEvent.class));
        ((Transformer)Mockito.verify((Object)resTransformer, (VerificationMode)Mockito.times((int)1))).process((MuleEvent)Matchers.any(MuleEvent.class));
        this.assertMessageSentSame(true);
        Assert.assertSame((Object)responseMessage, (Object)result.getMessage());
        this.assertEqualMessages(responseMessage, result.getMessage());
    }

    @Test
    public void testDefaultFlowNonBlocking() throws Exception {
        Transformer reqTransformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)reqTransformer.process((MuleEvent)Matchers.any(MuleEvent.class))).then(this.echoEventAnswer);
        Transformer resTransformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)resTransformer.process((MuleEvent)Matchers.any(MuleEvent.class))).then(this.echoEventAnswer);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, reqTransformer, resTransformer, MessageExchangePattern.REQUEST_RESPONSE, null);
        SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
        MuleEvent event = this.getNonBlockingTestEventUsingFlow("Test Message", (ReplyToHandler)nullReplyToHandler);
        MuleEvent response = endpoint.process(event);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.equalTo((Object)NonBlockingVoidMuleEvent.getInstance()));
        Assert.assertThat((Object)this.getNonBlockingResponse(nullReplyToHandler, response), (Matcher)CoreMatchers.equalTo((Object)event));
        ((Transformer)Mockito.verify((Object)reqTransformer, (VerificationMode)Mockito.times((int)1))).process(event);
        ((Transformer)Mockito.verify((Object)resTransformer, (VerificationMode)Mockito.times((int)1))).process(event);
    }

    @Test
    public void testDefaultFlowNonBlockingError() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint("test://AlwaysFail", null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
        MuleEvent event = this.getNonBlockingTestEventUsingFlow("Test Message", (ReplyToHandler)nullReplyToHandler);
        MuleEvent response = endpoint.process(event);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.equalTo((Object)NonBlockingVoidMuleEvent.getInstance()));
        try {
            this.getNonBlockingResponse(nullReplyToHandler, response);
            Assert.fail((String)"Exception Expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(MessagingException.class));
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RoutingException.class));
        }
    }

    @Test
    public void testDefaultFlowAsync() throws Exception {
        Transformer reqTransformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)reqTransformer.process((MuleEvent)Matchers.any(MuleEvent.class))).then(this.echoEventAnswer);
        Transformer resTransformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)resTransformer.process((MuleEvent)Matchers.any(MuleEvent.class))).then(this.echoEventAnswer);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, reqTransformer, resTransformer, MessageExchangePattern.ONE_WAY, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        ((Transformer)Mockito.verify((Object)reqTransformer, (VerificationMode)Mockito.times((int)1))).process((MuleEvent)Matchers.any(MuleEvent.class));
        ((Transformer)Mockito.verify((Object)resTransformer, (VerificationMode)Mockito.never())).process((MuleEvent)Matchers.any(MuleEvent.class));
        this.dispacher.latch.await(5000L, TimeUnit.MILLISECONDS);
        this.assertMessageSentSame(false);
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)result);
    }

    @Test
    public void testSecurityFilterAccept() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(true), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageSentSame(true);
        Assert.assertSame((Object)responseMessage, (Object)result.getMessage());
        this.assertEqualMessages(responseMessage, result.getMessage());
    }

    @Test
    public void testSecurityFilterNotAccept() throws Exception {
        AbstractMessageProcessorTestCase.TestSecurityNotificationListener securityNotificationListener = new AbstractMessageProcessorTestCase.TestSecurityNotificationListener();
        muleContext.registerListener((ServerNotificationListener)securityNotificationListener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(false), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        RequestContext.setEvent((MuleEvent)this.testOutboundEvent);
        try {
            endpoint.process(this.testOutboundEvent);
            Assert.fail((String)"Exception expected");
        }
        catch (TestSecurityFilter.StaticMessageUnauthorisedException e) {
            this.testOutboundEvent.getFlowConstruct().getExceptionListener().handleException((Exception)((Object)e), this.testOutboundEvent);
        }
        this.assertMessageNotSent();
        Assert.assertTrue((boolean)securityNotificationListener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)401L, (long)securityNotificationListener.securityNotification.getAction());
        Assert.assertEquals((Object)securityNotificationListener.securityNotification.getResourceIdentifier(), (Object)TestSecurityFilter.StaticMessageUnauthorisedException.class.getName());
    }

    @Test
    public void testSendNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener(2);
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent();
        endpoint.process(outboundEvent);
        Assert.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)2L, (long)listener.messageNotificationList.size());
        Assert.assertEquals((long)803L, (long)listener.messageNotificationList.get(0).getAction());
        Assert.assertEquals((long)852L, (long)listener.messageNotificationList.get(1).getAction());
        Assert.assertEquals((Object)endpoint.getEndpointURI().getUri().toString(), (Object)listener.messageNotificationList.get(0).getEndpoint());
        Assert.assertEquals((Object)endpoint.getEndpointURI().getUri().toString(), (Object)listener.messageNotificationList.get(1).getEndpoint());
        Assert.assertTrue((boolean)(listener.messageNotificationList.get(0).getSource() instanceof MuleMessage));
        Assert.assertTrue((boolean)(listener.messageNotificationList.get(1).getSource() instanceof MuleMessage));
        Assert.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotificationList.get(0).getSource().getPayload());
        Assert.assertEquals((Object)RESPONSE_MESSAGE, (Object)listener.messageNotificationList.get(1).getSource().getPayload());
    }

    @Test
    public void testDispatchNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener(2);
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent();
        endpoint.process(outboundEvent);
        Assert.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)2L, (long)listener.messageNotificationList.size());
        Assert.assertEquals((long)802L, (long)listener.messageNotificationList.get(0).getAction());
        Assert.assertEquals((long)851L, (long)listener.messageNotificationList.get(1).getAction());
        Assert.assertEquals((Object)endpoint.getEndpointURI().getUri().toString(), (Object)listener.messageNotificationList.get(0).getEndpoint());
        Assert.assertEquals((Object)endpoint.getEndpointURI().getUri().toString(), (Object)listener.messageNotificationList.get(1).getEndpoint());
        Assert.assertTrue((boolean)(listener.messageNotificationList.get(0).getSource() instanceof MuleMessage));
        Assert.assertTrue((boolean)(listener.messageNotificationList.get(1).getSource() instanceof MuleMessage));
        Assert.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotificationList.get(0).getSource().getPayload());
        Assert.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotificationList.get(1).getSource().getPayload());
    }

    @Test
    public void testTransformers() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, (Transformer)new OutboundAppendTransformer(), (Transformer)new ResponseAppendTransformer(), MessageExchangePattern.REQUEST_RESPONSE, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(outboundEvent);
        this.assertMessageSent(true);
        Assert.assertEquals((Object)("Test Message" + OutboundAppendTransformer.APPEND_STRING), (Object)this.dispacher.sensedSendEvent.getMessageAsString());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)(RESPONSE_MESSAGE + ResponseAppendTransformer.APPEND_STRING), (Object)result.getMessageAsString());
    }

    @Test
    public void testConnectorNotStarted() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        endpoint.getConnector().stop();
        try {
            endpoint.process(this.testOutboundEvent);
            Assert.fail((String)"Exception expected");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    @Test
    public void testTimeoutSetOnEvent() throws Exception {
        int testTimeout = 999;
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        this.testOutboundEvent.getMessage().setOutboundProperty("MULE_EVENT_TIMEOUT", (Object)testTimeout);
        endpoint.process(this.testOutboundEvent);
        Assert.assertEquals((long)testTimeout, (long)this.dispacher.sensedSendEvent.getTimeout());
    }

    @Test
    public void testObjectAwareInjection() throws Exception {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://myTestUri", muleContext);
        endpointBuilder.addMessageProcessor((MessageProcessor)new AbstractMessageProcessorTestCase.ObjectAwareProcessor(this));
        OutboundEndpoint endpoint = endpointBuilder.buildOutboundEndpoint();
        endpoint.process(this.createTestOutboundEvent());
        AbstractMessageProcessorTestCase.ObjectAwareProcessor objectAware = (AbstractMessageProcessorTestCase.ObjectAwareProcessor)endpoint.getMessageProcessors().get(0);
        Assert.assertEquals((Object)muleContext, (Object)objectAware.context);
        Assert.assertEquals((Object)endpoint, (Object)objectAware.endpoint);
    }

    protected MuleEvent assertMessageSent(boolean sync) throws MuleException {
        MuleEvent event;
        if (sync) {
            Assert.assertNull((Object)this.dispacher.sensedDispatchEvent);
            Assert.assertNotNull((Object)this.dispacher.sensedSendEvent);
            event = this.dispacher.sensedSendEvent;
        } else {
            Assert.assertNull((Object)this.dispacher.sensedSendEvent);
            Assert.assertNotNull((Object)this.dispacher.sensedDispatchEvent);
            event = this.dispacher.sensedDispatchEvent;
        }
        Assert.assertNotNull((Object)event.getMessage());
        return event;
    }

    protected MuleEvent assertMessageSentSame(boolean sync) throws MuleException {
        MuleEvent event = this.assertMessageSent(sync);
        if (sync) {
            Assert.assertEquals((Object)this.testOutboundEvent, (Object)event);
        }
        Assert.assertEquals((Object)"Test Message", (Object)event.getMessageAsString());
        Assert.assertEquals((Object)"value1", (Object)event.getMessage().getOutboundProperty("prop1"));
        return event;
    }

    protected void assertMessageNotSent() throws MuleException {
        Assert.assertNull((Object)this.dispacher.sensedSendEvent);
        Assert.assertNull((Object)this.dispacher.sensedDispatchEvent);
    }

    protected void assertEqualMessages(MuleMessage expect, MuleMessage actual) {
        Assert.assertEquals((Object)expect.getPayload(), (Object)actual.getPayload());
        Assert.assertEquals((Object)expect.getEncoding(), (Object)actual.getEncoding());
        Assert.assertEquals((Object)expect.getUniqueId(), (Object)actual.getUniqueId());
        Assert.assertEquals((Object)expect.getExceptionPayload(), (Object)actual.getExceptionPayload());
    }

    protected OutboundEndpoint createOutboundEndpoint(String uri, Filter filter, SecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(uri, filter, securityFilter, in, response, exchangePattern, txConfig);
        this.dispacher = new FakeMessageDispatcher(endpoint);
        Connector connector = endpoint.getConnector();
        connector.setDispatcherFactory((MessageDispatcherFactory)new TestMessageDispatcherFactory(){

            @Override
            public MessageDispatcher create(OutboundEndpoint ep) throws MuleException {
                return OutboundEndpointTestCase.this.dispacher;
            }
        });
        return endpoint;
    }

    protected OutboundEndpoint createOutboundEndpoint(Filter filter, SecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        return this.createOutboundEndpoint("test://test", filter, securityFilter, in, response, exchangePattern, txConfig);
    }

    static class FakeMessageDispatcher
    extends TestMessageDispatcher {
        Latch latch = new Latch();
        MuleEvent sensedSendEvent;
        MuleEvent sensedDispatchEvent;

        public FakeMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        @Override
        protected MuleMessage doSend(MuleEvent event) throws Exception {
            this.sensedSendEvent = event;
            this.latch.countDown();
            return responseMessage;
        }

        @Override
        protected void doDispatch(MuleEvent event) throws Exception {
            this.sensedDispatchEvent = event;
            this.latch.countDown();
        }

        @Override
        protected void doSendNonBlocking(MuleEvent event, CompletionHandler<MuleMessage, Exception> completionHandler) {
            this.sensedSendEvent = event;
            this.latch.countDown();
            super.doSendNonBlocking(event, completionHandler);
        }
    }
}

