/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.registry.AbstractLifecycleTracker;
import org.mule.registry.TransientRegistry;
import org.mule.registry.TransientRegistryTestCase;

public class TransientRegistryLifecycleTestCase
extends TransientRegistryTestCase {
    @Test
    public void testObjectLifecycleWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        reg.dispose();
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testObjectBypassLifecycleWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker, (Object)1);
        reg.dispose();
        Assert.assertEquals((Object)"[setMuleContext, stop, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testObjectBypassInjectorsWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker, (Object)2);
        reg.dispose();
        Assert.assertEquals((Object)"[initialise, start, stop, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testObjectBypassLifecycleAndInjectorsWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker, (Object)3);
        reg.dispose();
        Assert.assertEquals((Object)"[stop, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testObjectLifecycleStatesWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        Assert.assertEquals((Object)"[setMuleContext]", (Object)tracker.getTracker().toString());
        reg.initialise();
        Assert.assertEquals((Object)"[setMuleContext, initialise]", (Object)tracker.getTracker().toString());
        reg.fireLifecycle("start");
        Assert.assertEquals((Object)"[setMuleContext, initialise, start]", (Object)tracker.getTracker().toString());
        try {
            reg.fireLifecycle("start");
            Assert.fail((String)"Registry is already started");
        }
        catch (Exception exception) {
            // empty catch block
        }
        reg.fireLifecycle("stop");
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop]", (Object)tracker.getTracker().toString());
        try {
            reg.fireLifecycle("stop");
            Assert.fail((String)"Registry is already stopped");
        }
        catch (Exception exception) {
            // empty catch block
        }
        reg.dispose();
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop, dispose]", (Object)tracker.getTracker().toString());
        try {
            reg.dispose();
            Assert.fail((String)"Registry is already disposed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testLifecycleState() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.fireLifecycle("initialise");
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        Assert.assertEquals((Object)"[setMuleContext, initialise, start]", (Object)tracker.getTracker().toString());
        reg.fireLifecycle("dispose");
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testLifecycleStateOutOfSequenceStartFirstWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        try {
            reg.fireLifecycle("start");
            Assert.fail((String)"Cannot start without initialising first");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        reg.fireLifecycle("initialise");
        reg.fireLifecycle("start");
        Assert.assertEquals((Object)"[setMuleContext, initialise, start]", (Object)tracker.getTracker().toString());
        reg.fireLifecycle("dispose");
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testLifecycleStateOutOfSequenceStopFirstWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        try {
            reg.fireLifecycle("stop");
            Assert.fail((String)"Cannot stop without starting first");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        reg.fireLifecycle("initialise");
        reg.fireLifecycle("start");
        reg.fireLifecycle("stop");
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop]", (Object)tracker.getTracker().toString());
        reg.fireLifecycle("dispose");
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop, dispose]", (Object)tracker.getTracker().toString());
    }

    public class JSR250ObjectLifecycleTracker
    implements MuleContextAware {
        private final List<String> tracker = new ArrayList<String>();

        public List<String> getTracker() {
            return this.tracker;
        }

        public void setMuleContext(MuleContext context) {
            this.tracker.add("setMuleContext");
        }

        @PostConstruct
        public void init() {
            this.tracker.add("initialise");
        }

        @PreDestroy
        public void dispose() {
            this.tracker.add("dispose");
        }
    }

    public class InterfaceBasedTracker
    extends AbstractLifecycleTracker {
    }
}

