/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.registry.RegistrationException;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.routing.EventGroup;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.UUID;
import org.mule.util.store.DefaultObjectStoreFactoryBean;

public class EventGroupTestCase
extends AbstractMuleContextTestCase {
    private PartitionableObjectStore<MuleEvent> objectStore;

    @Before
    public void before() throws RegistrationException {
        DefaultObjectStoreFactoryBean cfr_ignored_0 = (DefaultObjectStoreFactoryBean)muleContext.getRegistry().lookupObject(DefaultObjectStoreFactoryBean.class);
        this.objectStore = (PartitionableObjectStore)DefaultObjectStoreFactoryBean.createDefaultInMemoryObjectStore();
    }

    @Test
    public void concurrentIteration() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID(), muleContext);
        eg.initEventsStore(this.objectStore);
        Assert.assertFalse((boolean)eg.iterator().hasNext());
        eg.addEvent(EventGroupTestCase.getTestEvent("foo1"));
        eg.addEvent(EventGroupTestCase.getTestEvent("foo2"));
        Assert.assertTrue((boolean)eg.iterator().hasNext());
        Iterator i = eg.iterator();
        Assert.assertNotNull(i.next());
        eg.addEvent(EventGroupTestCase.getTestEvent("foo3"));
        Assert.assertNotNull(i.next());
        eg.addEvent(EventGroupTestCase.getTestEvent("foo4"));
        Assert.assertFalse((boolean)i.hasNext());
        Assert.assertEquals((long)4L, (long)eg.size());
    }

    @Test
    public void eventGroupEquality() throws ObjectStoreException {
        EventGroup g1 = new EventGroup((Object)"foo", muleContext);
        g1.initEventsStore(this.objectStore);
        EventGroup g2 = new EventGroup((Object)"foo", muleContext);
        g2.initEventsStore(this.objectStore);
        EventGroup g3 = new EventGroup((Object)"bar", muleContext);
        g3.initEventsStore(this.objectStore);
        Assert.assertEquals((Object)g1, (Object)g2);
        Assert.assertFalse((boolean)g1.equals((Object)g3));
        MyEventGroup mg = new MyEventGroup("foo");
        Assert.assertEquals((Object)g1, (Object)((Object)mg));
        Assert.assertEquals((Object)((Object)mg), (Object)g1);
        mg = new MyEventGroup("bar");
        Assert.assertFalse((boolean)g1.equals((Object)mg));
        Assert.assertFalse((boolean)mg.equals(g1));
    }

    @Test
    public void eventGroupHashCode() throws ObjectStoreException {
        String uuid = UUID.getUUID();
        EventGroup g1 = new EventGroup((Object)uuid, muleContext);
        g1.initEventsStore(this.objectStore);
        EventGroup g2 = new EventGroup((Object)uuid, muleContext);
        g2.initEventsStore(this.objectStore);
        EventGroup g3 = new EventGroup((Object)UUID.getUUID(), muleContext);
        g3.initEventsStore(this.objectStore);
        Assert.assertEquals((long)g1.hashCode(), (long)g2.hashCode());
        Assert.assertEquals((Object)g1, (Object)g2);
        Assert.assertFalse((g1.hashCode() == g3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)g1.equals((Object)g3));
        Assert.assertFalse((boolean)g3.equals((Object)g1));
        HashSet<EventGroup> s = new HashSet<EventGroup>();
        s.add(g1);
        Assert.assertTrue((boolean)s.contains(g1));
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertTrue((boolean)s.contains(g2));
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertFalse((boolean)s.contains(g3));
        Assert.assertTrue((boolean)s.add(g3));
        Assert.assertTrue((boolean)s.contains(g3));
        Assert.assertEquals((long)2L, (long)s.size());
    }

    @Test
    public void eventGroupComparison() throws InterruptedException, ObjectStoreException {
        String uuid = UUID.getUUID();
        EventGroup g1 = new EventGroup((Object)uuid, muleContext);
        g1.initEventsStore(this.objectStore);
        EventGroup g2 = new EventGroup((Object)uuid, muleContext);
        g2.initEventsStore(this.objectStore);
        EventGroup g3 = new EventGroup((Object)UUID.getUUID(), muleContext);
        g3.initEventsStore(this.objectStore);
        try {
            g1.compareTo(null);
            Assert.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)g1.compareTo(g2));
        Assert.assertTrue((g1.compareTo(g3) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((g3.compareTo(g1) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((g3.compareTo(g2) != 0 ? 1 : 0) != 0);
        g1 = new EventGroup(new Object(), muleContext);
        Thread.sleep(10L);
        g2 = new EventGroup(new Object(), muleContext);
        Assert.assertTrue((g1.compareTo(g2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((g2.compareTo(g1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void eventGroupConversionToArray() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID(), muleContext);
        eg.initEventsStore(this.objectStore);
        eg.addEvent(EventGroupTestCase.getTestEvent("foo1"));
        eg.addEvent(EventGroupTestCase.getTestEvent("foo2"));
        Object[] array1 = IteratorUtils.toArray((Iterator)eg.iterator(false));
        Object[] array2 = eg.toArray(false);
        Assert.assertTrue((boolean)Arrays.equals(array1, array2));
    }

    @Test
    public void eventGroupConversionToString() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID(), muleContext);
        eg.initEventsStore(this.objectStore);
        String es = eg.toString();
        Assert.assertTrue((boolean)es.endsWith("events=0}"));
        MuleEvent firstEvent = EventGroupTestCase.getTestEvent("foo");
        String firstId = firstEvent.getMessage().getUniqueId();
        eg.addEvent(firstEvent);
        es = eg.toString();
        Assert.assertTrue((boolean)es.contains("events=1"));
        Assert.assertTrue((boolean)es.endsWith("[" + firstId + "]}"));
        DefaultMuleEvent secondEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"foo2", muleContext), EventGroupTestCase.getTestEvent("foo2"));
        String secondId = secondEvent.getMessage().getUniqueId();
        eg.addEvent((MuleEvent)secondEvent);
        es = eg.toString();
        Assert.assertTrue((boolean)es.contains("events=2"));
        Assert.assertTrue((boolean)es.contains(firstId));
        Assert.assertTrue((boolean)es.contains(secondId));
    }

    @Test
    public void mergedSessions() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID(), muleContext);
        eg.initEventsStore(this.objectStore);
        Assert.assertFalse((boolean)eg.iterator().hasNext());
        MuleEvent event1 = EventGroupTestCase.getTestEvent("foo1");
        MuleEvent event2 = EventGroupTestCase.getTestEvent("foo2");
        MuleEvent event3 = EventGroupTestCase.getTestEvent("foo3");
        event1.getSession().setProperty("key1", (Serializable)((Object)"value1"));
        event1.getSession().setProperty("key2", (Serializable)((Object)"value2"));
        event2.getSession().setProperty("KEY2", (Serializable)((Object)"value2NEW"));
        event2.getSession().setProperty("key3", (Serializable)((Object)"value3"));
        event3.getSession().setProperty("key4", (Serializable)((Object)"value4"));
        eg.addEvent(event1);
        System.out.println(event1.getSession());
        eg.addEvent(event2);
        System.out.println(event2.getSession());
        eg.addEvent(event3);
        System.out.println(event3.getSession());
        MuleEvent result = eg.getMessageCollectionEvent();
        Assert.assertEquals((Object)"value1", (Object)result.getSession().getProperty("key1"));
        Assert.assertEquals((Object)"value3", (Object)result.getSession().getProperty("key3"));
        Assert.assertEquals((Object)"value4", (Object)result.getSession().getProperty("key4"));
    }

    private static class MyEventGroup
    extends EventGroup {
        private static final long serialVersionUID = 1L;

        public MyEventGroup(Object groupId) {
            super(groupId, muleContext);
        }

        public MyEventGroup(Object groupId, int expectedSize) {
            super(groupId, muleContext, expectedSize, "EventGroupTestCase");
        }
    }
}

