/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.LineIterator;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.mule.RequestContext;
import org.mule.tck.junit4.rule.WarningTimeout;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleTestCase {
    public static final String TESTING_MODE_PROPERTY_NAME = "mule.testingMode";
    public static final int DEFAULT_TEST_TIMEOUT_SECS = 60;
    public static final String TEST_TIMEOUT_SYSTEM_PROPERTY = "mule.test.timeoutSecs";
    private static final boolean verbose;
    private static Boolean excluded;
    private static final Logger LOGGER;
    private boolean offline = "true".equalsIgnoreCase(System.getProperty("org.mule.offline"));
    private int testTimeoutSecs = this.getTimeoutSystemProperty();
    @Rule
    public TestName name = new TestName();
    @Rule
    public TestRule globalTimeout = this.createTestTimeoutRule();
    private static String testCaseName;
    private static final transient String THREAD_RESULT_LINE;

    public AbstractMuleTestCase() {
        if (excluded == null) {
            excluded = this.isTestIncludedInExclusionFile(this);
        }
    }

    protected TestRule createTestTimeoutRule() {
        int millisecondsTimeout = this.getTestTimeoutSecs() * 1000;
        if (this.isFailOnTimeout()) {
            return new DisableOnDebug((TestRule)new Timeout(millisecondsTimeout));
        }
        return new WarningTimeout(millisecondsTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTestIncludedInExclusionFile(AbstractMuleTestCase test) {
        boolean result;
        block5: {
            result = false;
            final String testName = test.getClass().getName();
            try {
                URL classUrl = ClassUtils.getClassPathRoot(test.getClass());
                URLClassLoader tempClassLoader = new URLClassLoader(new URL[]{classUrl});
                URL fileUrl = tempClassLoader.getResource("mule-test-exclusions.txt");
                if (fileUrl == null) break block5;
                InputStream in = null;
                try {
                    in = fileUrl.openStream();
                    LineIterator lines = IOUtils.lineIterator((InputStream)in, (String)"UTF-8");
                    result = IteratorUtils.filteredIterator((Iterator)lines, (Predicate)new Predicate(){

                        public boolean evaluate(Object object) {
                            return StringUtils.equals((String)testName, (String)StringUtils.trimToEmpty((String)((String)object)));
                        }
                    }).hasNext();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    protected int getTimeoutSystemProperty() {
        String timeoutString = System.getProperty(TEST_TIMEOUT_SYSTEM_PROPERTY, null);
        if (timeoutString == null) {
            String variableName = TEST_TIMEOUT_SYSTEM_PROPERTY.toUpperCase().replace(".", "_");
            timeoutString = System.getenv(variableName);
        }
        int result = 60;
        if (timeoutString != null) {
            try {
                result = Integer.parseInt(timeoutString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    protected boolean isDisabledInThisEnvironment() {
        return false;
    }

    protected boolean isExcluded() {
        return excluded;
    }

    protected boolean isDisabledInThisEnvironment(String testMethodName) {
        return false;
    }

    public boolean isOffline(String method) {
        if (this.offline) {
            LOGGER.warn(StringMessageUtils.getBoilerPlate((String)("Working offline cannot run test: " + method), (char)'=', (int)80));
        }
        return this.offline;
    }

    public int getTestTimeoutSecs() {
        return this.testTimeoutSecs;
    }

    @Before
    public final void initializeMuleTest() {
        this.skipTestWhenExcluded();
        this.skipTestWhenDisabledInCurrentEnvironment();
        this.printTestHeader();
    }

    private void printTestHeader() {
        if (verbose) {
            System.out.println(StringMessageUtils.getBoilerPlate((String)this.getTestHeader(), (char)'=', (int)80));
        }
    }

    protected String getTestHeader() {
        return "Testing: " + this.name.getMethodName();
    }

    private void skipTestWhenExcluded() {
        Assume.assumeThat((Object)this, (Matcher)new BaseMatcher<AbstractMuleTestCase>(){

            public boolean matches(Object o) {
                return !AbstractMuleTestCase.this.isExcluded();
            }

            public void describeTo(Description description) {
                description.appendText("Test " + AbstractMuleTestCase.this.name.getMethodName() + " is excluded");
            }
        });
    }

    private void skipTestWhenDisabledInCurrentEnvironment() {
        Assume.assumeThat((Object)this, (Matcher)new BaseMatcher<AbstractMuleTestCase>(){

            public boolean matches(Object o) {
                return !AbstractMuleTestCase.this.isDisabledInThisEnvironment() && !AbstractMuleTestCase.this.isDisabledInThisEnvironment(AbstractMuleTestCase.this.name.getMethodName());
            }

            public void describeTo(Description description) {
                description.appendText("Test " + AbstractMuleTestCase.this.name.getMethodName() + " disabled in this environment");
            }
        });
    }

    protected boolean isFailOnTimeout() {
        return true;
    }

    @After
    public final void clearRequestContext() {
        RequestContext.clear();
    }

    @AfterClass
    public static final void clearExcludedFlag() {
        excluded = null;
    }

    private static List<String> collectThreadNames() {
        ArrayList<String> threadNames = new ArrayList<String>();
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.isAlive()) continue;
            threadNames.add(t.getName() + " - " + t.getId());
        }
        Collections.sort(threadNames);
        return threadNames;
    }

    @BeforeClass
    public static void clearTestCaseName() {
        testCaseName = null;
    }

    @Before
    public void takeTestCaseName() {
        if (testCaseName == null) {
            testCaseName = this.getClass().getName();
        }
    }

    @AfterClass
    public static void dumpFilteredThreadsInTest() {
        List<String> currentThreads = AbstractMuleTestCase.collectThreadNames();
        int filteredThreads = 0;
        StringBuilder builder = new StringBuilder();
        for (String threadName : currentThreads) {
            if (AbstractMuleTestCase.nameIn(threadName, "Finalizer", "Monitor Ctrl-Break", "Reference Handler", "Signal Dispatcher", "main")) continue;
            builder.append("\n-> ").append(threadName);
            ++filteredThreads;
        }
        if (filteredThreads > 0) {
            AbstractMuleTestCase.logThreadsResult(String.format("Hung threads count: %d. Test case: %s. Thread names:%s", filteredThreads, testCaseName, builder.toString()));
        } else {
            AbstractMuleTestCase.logThreadsResult(String.format("No hung threads. Test case: %s", testCaseName));
        }
    }

    private static boolean nameIn(String threadName, String ... values) {
        String threadNameLowercase = threadName.toLowerCase();
        if (values != null) {
            for (String value : values) {
                if (!threadNameLowercase.startsWith(value.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static void logThreadsResult(String result) {
        LOGGER.warn(String.format("\n%s\n%s\n%s\n", THREAD_RESULT_LINE, result, THREAD_RESULT_LINE));
    }

    static {
        excluded = null;
        String muleOpts = SystemUtils.getenv((String)"MULE_TEST_OPTS");
        if (StringUtils.isNotBlank((String)muleOpts)) {
            Map parsedOpts = SystemUtils.parsePropertyDefinitions((String)muleOpts);
            String optVerbose = (String)parsedOpts.get("mule.verbose");
            verbose = Boolean.valueOf(optVerbose);
        } else {
            verbose = true;
        }
        System.setProperty(TESTING_MODE_PROPERTY_NAME, "");
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
        LOGGER = LoggerFactory.getLogger(AbstractMuleTestCase.class);
        THREAD_RESULT_LINE = StringUtils.repeat((char)'-', (int)80);
    }
}

