/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import com.google.common.base.Charsets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

@SmallTest
public class TransformerSourceTypeEnforcementTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.muleConfiguration.getDefaultEncoding()).thenReturn((Object)Charsets.UTF_8.name());
        Mockito.when((Object)this.muleConfiguration.useExtendedTransformations()).thenReturn((Object)true);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
    }

    @Test
    public void ignoresBadInputIfEnforcementOff() throws TransformerException {
        AbstractTransformer transformer = this.createDummyTransformer(true);
        this.setTransformationEnforcement(false);
        Object result = transformer.transform((Object)"TEST");
        Assert.assertEquals((Object)"TEST", (Object)result);
        ((MuleConfiguration)Mockito.verify((Object)this.muleConfiguration, (VerificationMode)Mockito.times((int)1))).useExtendedTransformations();
    }

    @Test
    public void rejectsBadInputIfEnforcementOn() throws TransformerException {
        AbstractTransformer transformer = this.createDummyTransformer(true);
        this.setTransformationEnforcement(true);
        try {
            transformer.transform((Object)"TEST");
            Assert.fail((String)"Transformation should fail because source type is not supported");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        ((MuleConfiguration)Mockito.verify((Object)this.muleConfiguration, (VerificationMode)Mockito.times((int)1))).useExtendedTransformations();
    }

    @Test
    public void rejectsBadInputUsingDefaultEnforcement() throws TransformerException {
        AbstractTransformer transformer = this.createDummyTransformer(true);
        try {
            transformer.transform((Object)"TEST");
            Assert.fail((String)"Transformation should fail because source type is not supported");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Test
    public void transformsValidSourceTypeWithNoCheckForEnforcement() throws TransformerException {
        AbstractTransformer transformer = this.createDummyTransformer(true);
        transformer.sourceTypes.add(DataTypeFactory.STRING);
        transformer.returnType = DataTypeFactory.STRING;
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
        Object result = transformer.transform((Object)"TEST");
        Assert.assertEquals((Object)"TRANSFORMED", (Object)result);
        ((MuleConfiguration)Mockito.verify((Object)this.muleConfiguration, (VerificationMode)Mockito.times((int)0))).useExtendedTransformations();
    }

    private void setTransformationEnforcement(boolean enforce) {
        Mockito.when((Object)this.muleConfiguration.useExtendedTransformations()).thenReturn((Object)enforce);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
    }

    private AbstractTransformer createDummyTransformer(boolean ignoreBadInput) {
        AbstractTransformer result = new AbstractTransformer(){

            protected Object doTransform(Object src, String enc) throws TransformerException {
                return "TRANSFORMED";
            }
        };
        result.sourceTypes.add(DataTypeFactory.BYTE_ARRAY);
        result.setMuleContext(this.muleContext);
        result.setIgnoreBadInput(ignoreBadInput);
        return result;
    }
}

