/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.ObjectInputStream;
import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.util.queue.DefaultQueueConfiguration;
import org.mule.util.queue.DefaultQueueStore;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueStore;
import org.mule.util.queue.QueueStoreTestCase;

public class DualRandomAccessFileQueueStoreTestCase
extends QueueStoreTestCase {
    @Override
    protected QueueStore createQueueInfoDelegate(int capacity, MuleContext muleContext) {
        return new DefaultQueueStore("testQueue", muleContext, (QueueConfiguration)new DefaultQueueConfiguration(capacity, true));
    }

    @Test
    public void containsDoesNotLoadEverythingInMemory() throws Exception {
        DefaultQueueStore queue = (DefaultQueueStore)this.createQueue();
        queue.offer((Serializable)new CounterClass(1), 0, 10L);
        CounterClass counterClassToSearch = new CounterClass(2);
        queue.offer((Serializable)counterClassToSearch, 0, 10L);
        queue.offer((Serializable)new CounterClass(3), 0, 10L);
        CounterClass.clearNumberOfInstances();
        queue.contains((Serializable)counterClassToSearch);
        Assert.assertThat((Object)CounterClass.numberOfInstances, (Matcher)Is.is((Object)2));
    }

    public static class CounterClass
    implements Serializable {
        public static int numberOfInstances = 0;
        private int value;

        public CounterClass(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static void clearNumberOfInstances() {
            numberOfInstances = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterClass that = (CounterClass)o;
            return this.value == that.value;
        }

        private void readObject(ObjectInputStream in) throws Exception {
            ++numberOfInstances;
            in.defaultReadObject();
        }

        public int hashCode() {
            return this.value;
        }
    }
}

