/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.config.MuleConfiguration;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.FilenameUtils;

public class PropertiesMuleConfigurationFactory {
    private static Log logger = LogFactory.getLog(PropertiesMuleConfigurationFactory.class);
    private Properties properties;

    public static String getMuleAppConfiguration(String muleConfig) {
        String directory = FilenameUtils.getFullPath((String)muleConfig);
        String muleAppConfiguration = directory + "mule-app.properties";
        return muleAppConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesMuleConfigurationFactory(String muleAppConfiguration) {
        URL muleAppURL = ClassUtils.getResource(muleAppConfiguration, this.getClass());
        if (muleAppURL != null) {
            this.properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = muleAppURL.openStream();
                this.properties.load(inputStream);
            }
            catch (FileNotFoundException e) {
                logger.debug((Object)e);
            }
            catch (IOException e) {
                logger.debug((Object)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    public DefaultMuleConfiguration createConfiguration() {
        DefaultMuleConfiguration configuration = new DefaultMuleConfiguration();
        if (this.properties != null) {
            this.initializeFromProperties(configuration);
        }
        return configuration;
    }

    private void initializeFromProperties(MuleConfiguration configuration) {
        PropertiesMuleConfigurationFactory.initializeFromProperties(configuration, this.properties);
    }

    public static void initializeFromProperties(MuleConfiguration configuration, Map properties) {
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("sys.")) {
                String systemProperty = key.substring(4);
                System.setProperty(systemProperty, value);
                continue;
            }
            if (!key.startsWith("mule.config.")) continue;
            String configProperty = key.substring(12);
            try {
                BeanUtils.setProperty((Object)configuration, (String)configProperty, (Object)value);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e);
            }
        }
    }
}

