/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.el.mvel.datatype.ExpressionDataTypeResolver;
import org.mule.el.mvel.datatype.FlowVarExpressionDataTypeResolver;
import org.mule.el.mvel.datatype.PayloadExpressionDataTypeResolver;
import org.mule.el.mvel.datatype.PropertyExpressionDataTypeResolver;
import org.mule.el.mvel.datatype.SessionVarExpressionDataTypeResolver;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.transformer.types.DataTypeFactory;

public class MvelDataTypeResolver {
    private final List<ExpressionDataTypeResolver> resolvers;

    public MvelDataTypeResolver() {
        this(MvelDataTypeResolver.getDefaultDataTypeResolvers());
    }

    public MvelDataTypeResolver(List<ExpressionDataTypeResolver> resolvers) {
        this.resolvers = new LinkedList<ExpressionDataTypeResolver>(resolvers);
    }

    private static List<ExpressionDataTypeResolver> getDefaultDataTypeResolvers() {
        LinkedList<ExpressionDataTypeResolver> resolvers = new LinkedList<ExpressionDataTypeResolver>();
        resolvers.add(new PayloadExpressionDataTypeResolver());
        resolvers.add(new PropertyExpressionDataTypeResolver());
        resolvers.add(new FlowVarExpressionDataTypeResolver());
        resolvers.add(new SessionVarExpressionDataTypeResolver());
        return resolvers;
    }

    public DataType resolve(Object value, MuleMessage message, Serializable serializedExpression) {
        DataType result = null;
        if (serializedExpression instanceof CompiledExpression) {
            ExpressionDataTypeResolver resolver;
            CompiledExpression compiledExpression = (CompiledExpression)serializedExpression;
            Iterator<ExpressionDataTypeResolver> iterator = this.resolvers.iterator();
            while (iterator.hasNext() && (result = (resolver = iterator.next()).resolve(message, compiledExpression)) == null) {
            }
        }
        if (result == null) {
            Class type = value == null ? Object.class : value.getClass();
            result = DataTypeFactory.create(type, null);
        }
        return result;
    }
}

