/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.transport.AbstractConnector;
import org.mule.util.ObjectUtils;

public class OutboundNotificationMessageProcessor
implements MessageProcessor {
    private OutboundEndpoint endpoint;

    public OutboundNotificationMessageProcessor(OutboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        AbstractConnector connector = (AbstractConnector)this.endpoint.getConnector();
        if (connector.isEnableMessageEvents(event)) {
            int notificationAction = this.endpoint.getExchangePattern().hasResponse() ? 852 : 851;
            this.dispatchNotification(new EndpointMessageNotification(event.getMessage(), this.endpoint, event.getFlowConstruct(), notificationAction), event);
        }
        return event;
    }

    public void dispatchNotification(EndpointMessageNotification notification, MuleEvent event) {
        AbstractConnector connector = (AbstractConnector)this.endpoint.getConnector();
        if (notification != null && connector.isEnableMessageEvents(event)) {
            connector.fireNotification(notification, event);
        }
    }

    @Deprecated
    public void dispatchNotification(EndpointMessageNotification notification) {
        AbstractConnector connector = (AbstractConnector)this.endpoint.getConnector();
        if (notification != null && connector.isEnableMessageEvents()) {
            connector.fireNotification(notification);
        }
    }

    public EndpointMessageNotification createBeginNotification(MuleEvent event) {
        AbstractConnector connector = (AbstractConnector)this.endpoint.getConnector();
        if (connector.isEnableMessageEvents(event)) {
            int notificationAction = this.endpoint.getExchangePattern().hasResponse() ? 803 : 802;
            return new EndpointMessageNotification(event.getMessage(), this.endpoint, event.getFlowConstruct(), notificationAction);
        }
        return null;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }
}

