/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.resource.spi.work.Work;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ContinuousPollingReceiverWorker;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.TransactedPollingMessageReceiver;
import org.mule.transport.vm.VMConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageReceiver
extends TransactedPollingMessageReceiver {
    private VMConnector connector;

    public VMMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
        this.connector = (VMConnector)connector;
    }

    protected void schedule() throws RejectedExecutionException, NullPointerException, IllegalArgumentException {
        if (!this.endpoint.getExchangePattern().hasResponse()) {
            super.schedule();
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        if (!this.endpoint.getExchangePattern().hasResponse()) {
            QueueSession queueSession = this.connector.getQueueSession();
            Queue q = queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Current queue depth for queue: " + this.endpoint.getEndpointURI().getAddress() + " is: " + q.size()));
            }
        }
    }

    protected void doDisconnect() throws Exception {
    }

    public void onMessage(MuleMessage message) throws MuleException {
        DefaultMuleMessage newMessage = new DefaultMuleMessage(message.getPayload(), message, this.endpoint.getMuleContext());
        this.routeMessage((MuleMessage)newMessage);
    }

    protected void pollMessagesOutsideTransactions() throws Exception {
        ExecutionTemplate pt = this.createExecutionTemplate();
        List<MuleMessage> messages = this.getMessages();
        if (messages != null && messages.size() > 0) {
            for (MuleMessage message : messages) {
                this.getWorkManager().scheduleWork((Work)new MessageProcessorWorker((ExecutionTemplate<MuleEvent>)pt, this.endpoint.getMuleContext().getExceptionListener(), message));
            }
        }
    }

    public MuleMessage onCall(final MuleMessage message) throws MuleException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        MuleContext originaMuleContext = message.getMuleContext();
        try {
            Thread.currentThread().setContextClassLoader(this.endpoint.getMuleContext().getExecutionClassLoader());
            ((DefaultMuleMessage)message).setMuleContext(originaMuleContext);
            ExecutionTemplate executionTemplate = this.createExecutionTemplate();
            MuleEvent resultEvent = (MuleEvent)executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                public MuleEvent process() throws Exception {
                    MuleEvent event = VMMessageReceiver.this.routeMessage(message);
                    if (VMMessageReceiver.this.returnEvent(event)) {
                        MuleMessage returnedMessage = event.getMessage();
                        if (returnedMessage != null) {
                            returnedMessage.release();
                        }
                        return event;
                    }
                    return null;
                }
            });
            if (resultEvent != null) {
                DefaultMuleMessage resultMessage = (DefaultMuleMessage)resultEvent.getMessage();
                resultMessage.setMuleContext(originaMuleContext);
                this.connector.getSessionHandler().storeSessionInfoToMessage(resultEvent.getSession(), (MuleMessage)resultMessage);
                DefaultMuleMessage defaultMuleMessage = resultMessage;
                return defaultMuleMessage;
            }
            MuleMessage muleMessage = null;
            return muleMessage;
        }
        catch (MessagingException e) {
            MuleEvent event = e.getEvent();
            MuleMessage muleMessage = this.returnEvent(event) ? event.getMessage() : null;
            return muleMessage;
        }
        catch (MuleException e) {
            this.endpoint.getMuleContext().getExceptionListener().handleException((Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.endpoint.getMuleContext().getExceptionListener().handleException(e);
            throw new DefaultMuleException((Throwable)e);
        }
        finally {
            ((DefaultMuleMessage)message).setMuleContext(originaMuleContext);
            message.release();
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private boolean returnEvent(MuleEvent event) {
        return event != null && !VoidMuleEvent.getInstance().equals(event) && this.getEndpoint().getExchangePattern().hasResponse();
    }

    protected List<MuleMessage> getMessages() throws Exception {
        if (this.isReceiveMessagesInTransaction()) {
            MuleMessage message = this.getFirstMessage();
            if (message == null) {
                return null;
            }
            ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>(1);
            if (message instanceof DefaultMuleMessage) {
                ((DefaultMuleMessage)message).setMuleContext(this.endpoint.getMuleContext());
            }
            messages.add(message);
            return messages;
        }
        return this.getFirstMessages();
    }

    protected List<MuleMessage> getFirstMessages() throws Exception {
        QueueSession qs = (QueueSession)this.connector.getTransactionalResource(this.endpoint);
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        LinkedList<MuleMessage> messages = new LinkedList<MuleMessage>();
        int batchSize = this.getBatchSize(queue.size());
        MuleMessage message = this.getMessage(queue, this.connector.getQueueTimeout());
        if (message != null) {
            if (message instanceof DefaultMuleMessage) {
                ((DefaultMuleMessage)message).setMuleContext(this.endpoint.getMuleContext());
            }
            messages.add(message);
            for (int i = 0; i < batchSize && message != null; ++i) {
                message = this.getMessage(queue, 0);
                if (message == null) continue;
                messages.add((MuleMessage)new DefaultMuleMessage((Object)message, null, (Map)null, null, this.endpoint.getMuleContext(), message.getDataType()));
            }
        }
        return messages;
    }

    private MuleMessage getMessage(Queue queue, int timeout) throws InterruptedException {
        Serializable polledItem = queue.poll((long)timeout);
        if (polledItem instanceof MuleEvent) {
            return ((MuleEvent)polledItem).getMessage();
        }
        return (MuleMessage)polledItem;
    }

    protected MuleMessage getFirstMessage() throws Exception {
        QueueSession qs = (QueueSession)this.connector.getTransactionalResource(this.endpoint);
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        return this.getMessage(queue, this.connector.getQueueTimeout());
    }

    protected boolean hasNoMessages() {
        try {
            QueueSession qs = this.connector.getQueueSession();
            Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
            return queue.size() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected MuleEvent processMessage(Object msg) throws Exception {
        MuleMessage message = (MuleMessage)msg;
        if (message instanceof ThreadSafeAccess) {
            message = (MuleMessage)((ThreadSafeAccess)message).newThreadCopy();
        }
        return this.routeMessage(message);
    }

    protected PollingReceiverWorker createWork() {
        return new ContinuousPollingReceiverWorker((AbstractPollingMessageReceiver)this);
    }

    protected class MessageProcessorWorker
    implements Work,
    ExecutionCallback<MuleEvent> {
        private final ExecutionTemplate<MuleEvent> pt;
        private final Object message;
        private final SystemExceptionHandler exceptionHandler;

        public MessageProcessorWorker(ExecutionTemplate<MuleEvent> pt, SystemExceptionHandler exceptionHandler, Object message) {
            this.pt = pt;
            this.message = message;
            this.exceptionHandler = exceptionHandler;
        }

        public void release() {
        }

        public void run() {
            try {
                this.pt.execute((ExecutionCallback)this);
            }
            catch (MessagingException messagingException) {
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
        }

        public MuleEvent process() throws Exception {
            VMMessageReceiver.this.processMessage(this.message);
            return null;
        }
    }
}

