/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.util.Arrays;
import java.util.Collection;
import org.mule.api.MuleContext;
import org.mule.config.bootstrap.ArtifactType;
import org.mule.module.launcher.ArtifactDeploymentListener;
import org.mule.module.launcher.DeploymentListener;
import org.mule.util.Preconditions;

public class DeploymentListenerAdapter
implements DeploymentListener {
    private static final Collection<ArtifactType> DEPLOYMENT_LISTENER_ARTIFACT_SUPPORTED_TYPES = Arrays.asList(ArtifactType.DOMAIN, ArtifactType.APP);
    public static final String UNSUPPORTED_ARTIFACT_TYPE_ERROR = String.format("DeploymentListener only supports %s artifact types.", DEPLOYMENT_LISTENER_ARTIFACT_SUPPORTED_TYPES);
    private final ArtifactDeploymentListener artifactDeploymentListener;
    private final ArtifactType artifactType;

    public DeploymentListenerAdapter(ArtifactDeploymentListener artifactDeploymentListener, ArtifactType artifactType) {
        Preconditions.checkArgument((boolean)DEPLOYMENT_LISTENER_ARTIFACT_SUPPORTED_TYPES.contains(artifactType), (String)UNSUPPORTED_ARTIFACT_TYPE_ERROR);
        this.artifactType = artifactType;
        this.artifactDeploymentListener = artifactDeploymentListener;
    }

    @Override
    public void onDeploymentStart(String artifactName) {
        this.artifactDeploymentListener.onDeploymentStart(this.artifactType, artifactName);
    }

    @Override
    public void onDeploymentSuccess(String artifactName) {
        this.artifactDeploymentListener.onDeploymentSuccess(this.artifactType, artifactName);
    }

    @Override
    public void onDeploymentFailure(String artifactName, Throwable cause) {
        this.artifactDeploymentListener.onDeploymentFailure(this.artifactType, artifactName, cause);
    }

    @Override
    public void onUndeploymentStart(String artifactName) {
        this.artifactDeploymentListener.onUndeploymentStart(this.artifactType, artifactName);
    }

    @Override
    public void onUndeploymentSuccess(String artifactName) {
        this.artifactDeploymentListener.onUndeploymentSuccess(this.artifactType, artifactName);
    }

    @Override
    public void onUndeploymentFailure(String artifactName, Throwable cause) {
        this.artifactDeploymentListener.onUndeploymentFailure(this.artifactType, artifactName, cause);
    }

    @Override
    public void onMuleContextCreated(String artifactName, MuleContext context) {
        this.artifactDeploymentListener.onMuleContextCreated(artifactName, context);
    }

    @Override
    public void onMuleContextInitialised(String artifactName, MuleContext context) {
        this.artifactDeploymentListener.onMuleContextInitialised(artifactName, context);
    }

    @Override
    public void onMuleContextConfigured(String artifactName, MuleContext context) {
        this.artifactDeploymentListener.onMuleContextConfigured(artifactName, context);
    }
}

