/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import com.google.common.base.Optional;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.ArchiveDeployer;
import org.mule.module.launcher.CompositeDeploymentListener;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationStatus;
import org.mule.module.launcher.artifact.ArtifactFactory;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.Preconditions;

public class DomainArchiveDeployer
implements ArchiveDeployer<Domain> {
    private final transient Log logger = LogFactory.getLog(this.getClass());
    public static final String DOMAIN_BUNDLE_APPS_FOLDER = "apps";
    private final ArchiveDeployer<Domain> domainDeployer;
    private final DeploymentService deploymentService;
    private final ArchiveDeployer<Application> applicationDeployer;

    public DomainArchiveDeployer(ArchiveDeployer<Domain> domainDeployer, ArchiveDeployer<Application> applicationDeployer, DeploymentService deploymentService) {
        this.domainDeployer = domainDeployer;
        this.applicationDeployer = applicationDeployer;
        this.deploymentService = deploymentService;
    }

    @Override
    public Domain deployPackagedArtifact(String zip, Optional<Properties> deploymentProperties) throws DeploymentException {
        Domain domain = this.domainDeployer.deployPackagedArtifact(zip, deploymentProperties);
        this.deployBundledAppsIfDomainWasCreated(domain);
        return domain;
    }

    @Override
    public Domain deployExplodedArtifact(String artifactDir) throws DeploymentException {
        Domain domain = this.domainDeployer.deployExplodedArtifact(artifactDir);
        this.deployBundledAppsIfDomainWasCreated(domain);
        return domain;
    }

    @Override
    public Domain deployExplodedArtifact(String artifactDir, Optional<Properties> properties) throws DeploymentException {
        return this.deployExplodedArtifact(artifactDir);
    }

    @Override
    public boolean isUpdatedZombieArtifact(String artifactName) {
        return true;
    }

    @Override
    public boolean isZombieArtifact(String artifactName) {
        return false;
    }

    @Override
    public Domain deployPackagedArtifact(URL artifactAchivedUrl, Optional<Properties> deploymentProperties) {
        Domain domain = this.domainDeployer.deployPackagedArtifact(artifactAchivedUrl, deploymentProperties);
        this.deployBundledAppsIfDomainWasCreated(domain);
        return domain;
    }

    @Override
    public void undeployArtifact(String artifactId) {
        Collection<Application> domainApplications = this.findApplicationsAssociated(artifactId);
        if (!this.domainDeployer.isZombieArtifact(artifactId)) {
            for (Application domainApplication : domainApplications) {
                this.applicationDeployer.undeployArtifact(domainApplication.getArtifactName());
            }
        }
        this.domainDeployer.undeployArtifact(artifactId);
    }

    private Collection<Application> findApplicationsAssociated(String artifactId) {
        Domain domain = this.deploymentService.findDomain(artifactId);
        Preconditions.checkArgument((domain != null ? 1 : 0) != 0, (String)String.format("Domain %s does not exists", artifactId));
        return this.findApplicationsAssociated(domain);
    }

    private Collection<Application> findApplicationsAssociated(Domain domain) {
        return this.deploymentService.findDomainApplications(domain.getArtifactName());
    }

    @Override
    public File getDeploymentDirectory() {
        return this.domainDeployer.getDeploymentDirectory();
    }

    @Override
    public void setDeploymentListener(CompositeDeploymentListener deploymentListener) {
        this.domainDeployer.setDeploymentListener(deploymentListener);
    }

    @Override
    public void redeploy(Domain artifact) throws DeploymentException {
        Optional properties = Optional.absent();
        this.redeploy(artifact, (Optional<Properties>)properties);
    }

    @Override
    public Map<URL, Long> getArtifactsZombieMap() {
        return this.domainDeployer.getArtifactsZombieMap();
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<Domain> artifactFactory) {
        this.domainDeployer.setArtifactFactory(artifactFactory);
    }

    @Override
    public void undeployArtifactWithoutUninstall(Domain artifact) {
        throw new NotImplementedException("undeploy without uninstall is not supported for domains");
    }

    @Override
    public void deployArtifact(Domain artifact) {
        this.domainDeployer.deployArtifact(artifact);
    }

    private void deployBundledAppsIfDomainWasCreated(Domain domain) {
        if (domain != null) {
            this.deployBundleApps(domain);
        }
    }

    private void deployBundleApps(Domain domain) {
        File domainFolder = new File(this.domainDeployer.getDeploymentDirectory(), domain.getArtifactName());
        File appsFolder = new File(domainFolder, DOMAIN_BUNDLE_APPS_FOLDER);
        if (appsFolder.exists()) {
            File[] files;
            for (File file : files = appsFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".zip");
                }
            })) {
                try {
                    FileUtils.moveFile((File)file, (File)new File(MuleContainerBootstrapUtils.getMuleAppsDir(), file.getName()));
                }
                catch (IOException e) {
                    this.logger.warn((Object)e.getMessage());
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)e);
                }
            }
        }
    }

    @Override
    public void redeploy(Domain artifact, Optional<Properties> deploymentProperties) throws DeploymentException {
        Collection<Application> domainApplications = this.findApplicationsAssociated(artifact);
        HashMap<Application, ApplicationStatus> appStatusPreRedeployment = new HashMap<Application, ApplicationStatus>();
        for (Application domainApplication : domainApplications) {
            appStatusPreRedeployment.put(domainApplication, domainApplication.getStatus());
            this.applicationDeployer.undeployArtifactWithoutUninstall(domainApplication);
        }
        try {
            this.domainDeployer.redeploy(artifact, deploymentProperties);
        }
        catch (DeploymentException e) {
            this.logger.warn((Object)String.format("Failure during redeployment of domain %s, domain applications deployment will be skipped", artifact.getArtifactName()));
            throw e;
        }
        for (Application domainApplication : domainApplications) {
            try {
                Optional<Properties> modifiedProperties = this.addShouldStartProperty(deploymentProperties, (ApplicationStatus)((Object)appStatusPreRedeployment.get(domainApplication)));
                this.applicationDeployer.deployArtifact(domainApplication, modifiedProperties);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)e);
            }
        }
    }

    private Optional<Properties> addShouldStartProperty(Optional<Properties> deploymentProperties, ApplicationStatus applicationStatus) {
        Properties newProperties = deploymentProperties.isPresent() ? new Properties((Properties)deploymentProperties.get()) : new Properties();
        boolean startArtifact = applicationStatus.equals((Object)ApplicationStatus.STARTED) || applicationStatus.equals((Object)ApplicationStatus.DEPLOYMENT_FAILED);
        newProperties.setProperty("startArtifactOnDeployment", String.valueOf(startArtifact));
        return Optional.of((Object)newProperties);
    }

    @Override
    public void deployArtifact(Domain artifact, Optional<Properties> deploymentProperties) throws DeploymentException {
        this.domainDeployer.deployArtifact(artifact, deploymentProperties);
    }

    @Override
    public Domain deployPackagedArtifact(String zip) throws DeploymentException {
        Optional properties = Optional.absent();
        return this.deployPackagedArtifact(zip, properties);
    }
}

