/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.mule.module.launcher.ArtifactDeploymentTemplate;
import org.mule.module.launcher.DefaultArchiveDeployer;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationStatus;
import org.mule.module.launcher.artifact.Artifact;
import org.mule.module.launcher.domain.Domain;

public final class DomainDeploymentTemplate
implements ArtifactDeploymentTemplate {
    private Collection<Application> domainApplications = Collections.emptyList();
    private final DefaultArchiveDeployer<Application> applicationDeployer;
    private final DeploymentService deploymentservice;

    public DomainDeploymentTemplate(DefaultArchiveDeployer<Application> applicationDeployer, DeploymentService deploymentservice) {
        this.applicationDeployer = applicationDeployer;
        this.deploymentservice = deploymentservice;
    }

    @Override
    public void preRedeploy(Artifact domain) {
        if (domain instanceof Domain) {
            this.domainApplications = this.deploymentservice.findDomainApplications(domain.getArtifactName());
            for (Application domainApplication : this.domainApplications) {
                this.applicationDeployer.undeployArtifactWithoutUninstall(domainApplication);
            }
        }
    }

    @Override
    public void postRedeploy(Artifact domain) {
        this.postRedeploy(domain, Collections.emptyMap());
    }

    @Override
    public void postRedeploy(Artifact domain, Map<Application, ApplicationStatus> appStatusPreRedeployment) {
        if (domain != null && !this.domainApplications.isEmpty()) {
            for (Application domainApplication : this.domainApplications) {
                this.applicationDeployer.preTrackArtifact(domainApplication);
                if (!this.applicationDeployer.isUpdatedZombieArtifact(domainApplication.getArtifactName())) continue;
                Optional<Properties> property = this.addShouldStartProperty(appStatusPreRedeployment.get(domainApplication));
                this.applicationDeployer.deployExplodedArtifact(domainApplication.getArtifactName(), property);
            }
        }
        this.domainApplications = Collections.emptyList();
    }

    private Optional<Properties> addShouldStartProperty(ApplicationStatus applicationStatus) {
        Properties newProperties = new Properties();
        boolean startArtifact = ApplicationStatus.STARTED.equals((Object)applicationStatus) || ApplicationStatus.DEPLOYMENT_FAILED.equals((Object)applicationStatus);
        newProperties.setProperty("startArtifactOnDeployment", String.valueOf(startArtifact));
        return Optional.of((Object)newProperties);
    }
}

