/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.util.HashMap;
import java.util.Map;
import org.mule.module.launcher.application.ApplicationStatus;

public class ApplicationStatusMapper {
    private static final Map<String, ApplicationStatus> statusMapping = ApplicationStatusMapper.getStatusMapping();

    public static ApplicationStatus getApplicationStatus(String currentPhase) {
        ApplicationStatus applicationStatus = statusMapping.get(currentPhase);
        if (applicationStatus == null) {
            throw new IllegalStateException("Unknown lifecycle phase: " + currentPhase);
        }
        return applicationStatus;
    }

    private static Map<String, ApplicationStatus> getStatusMapping() {
        HashMap<String, ApplicationStatus> statusMapping = new HashMap<String, ApplicationStatus>();
        statusMapping.put("not in lifecycle", ApplicationStatus.CREATED);
        statusMapping.put("dispose", ApplicationStatus.DESTROYED);
        statusMapping.put("stop", ApplicationStatus.STOPPED);
        statusMapping.put("start", ApplicationStatus.STARTED);
        statusMapping.put("initialise", ApplicationStatus.INITIALISED);
        return statusMapping;
    }
}

