/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.resource.spi.work.Work;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.construct.Flow;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.retry.RetryPolicyExhaustedException;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.ftp.FtpConnector;
import org.mule.transport.ftp.FtpMuleMessageFactory;

public class FtpMessageReceiver
extends AbstractPollingMessageReceiver {
    private static final int FTP_LIST_PAGE_SIZE = 25;
    protected final FtpConnector connector;
    protected final FilenameFilter filenameFilter;
    protected final Set<String> scheduledFiles = Collections.synchronizedSet(new HashSet());
    protected final Set<String> currentFiles = Collections.synchronizedSet(new HashSet());
    private boolean poolOnPrimaryInstanceOnly;

    public FtpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, long frequency) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setFrequency(frequency);
        this.connector = (FtpConnector)connector;
        this.filenameFilter = endpoint.getFilter() instanceof FilenameFilter ? (FilenameFilter)endpoint.getFilter() : null;
    }

    protected void doInitialise() throws InitialisationException {
        boolean synchronousProcessing = false;
        if (this.getFlowConstruct() instanceof Flow) {
            synchronousProcessing = ((Flow)this.getFlowConstruct()).getProcessingStrategy() instanceof SynchronousProcessingStrategy;
        }
        this.poolOnPrimaryInstanceOnly = Boolean.valueOf(System.getProperty("mule.transport.ftp.singlepollinstance", "false")) != false || !synchronousProcessing && ((AbstractConnector)this.getConnector()).getReceiverThreadingProfile().isDoThreading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        FTPFile[] files = this.listFiles();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Poll encountered " + files.length + " new file(s)"));
        }
        Set<String> set = this.scheduledFiles;
        synchronized (set) {
            for (FTPFile file : files) {
                if (this.getLifecycleState().isStopping()) break;
                String fileName = file.getName();
                if (this.scheduledFiles.contains(fileName) || this.currentFiles.contains(fileName)) continue;
                this.scheduledFiles.add(fileName);
                this.getWorkManager().scheduleWork((Work)new FtpWork(fileName, file));
            }
        }
    }

    protected boolean pollOnPrimaryInstanceOnly() {
        return this.poolOnPrimaryInstanceOnly;
    }

    protected FTPFile[] listFiles() throws Exception {
        final FTPClient[] client = new FTPClient[]{null};
        RetryCallback callbackReconnection = new RetryCallback(){

            public void doWork(RetryContext context) throws Exception {
                client[0] = FtpMessageReceiver.this.connector.createFtpClient(FtpMessageReceiver.this.endpoint);
            }

            public String getWorkDescription() {
                return FtpMessageReceiver.this.getConnectionDescription();
            }

            public Connector getWorkOwner() {
                return FtpMessageReceiver.this.connector;
            }
        };
        if (this.retryTemplate.isSynchronous()) {
            try {
                RetryContext retryContext = this.retryTemplate.execute(callbackReconnection, this.connector.getMuleContext().getWorkManager());
                if (client[0] != null) {
                    return this.filesToFTPArray(client[0]);
                }
                throw new ConnectException(retryContext.getLastFailure(), (Connectable)this);
            }
            catch (RetryPolicyExhaustedException retryPolicyExhaustedException) {
                if (retryPolicyExhaustedException.getCause() instanceof ConnectException) {
                    throw new ConnectException((Throwable)retryPolicyExhaustedException, (Connectable)this.connector);
                }
                throw retryPolicyExhaustedException;
            }
        }
        throw new IllegalArgumentException("FTP Connector doesn't support asynchronous retry policies.");
    }

    private FTPFile[] filesToFTPArray(FTPClient client) throws Exception {
        boolean disposeFtpClient = false;
        try {
            FTPFile[] fTPFileArray;
            FTPListParseEngine engine = client.initiateListParsing();
            FTPFile[] files = null;
            ArrayList<FTPFile> v = new ArrayList<FTPFile>();
            while (engine.hasNext() && !this.getLifecycleState().isStopping()) {
                files = engine.getNext(25);
                if (files == null || files.length == 0) {
                    fTPFileArray = files;
                    return fTPFileArray;
                }
                for (FTPFile file : files) {
                    if (!file.isFile() || this.filenameFilter != null && !this.filenameFilter.accept(null, file.getName())) continue;
                    v.add(file);
                }
            }
            if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                throw new IOException("Failed to list files. Ftp error: " + client.getReplyCode());
            }
            fTPFileArray = v.toArray(new FTPFile[v.size()]);
            return fTPFileArray;
        }
        catch (IOException e) {
            disposeFtpClient = true;
            throw new ConnectException((Throwable)e, (Connectable)this.connector);
        }
        finally {
            if (client != null) {
                this.connector.releaseFtp(this.endpoint, client, disposeFtpClient);
            }
        }
    }

    protected void initializeMessageFactory() throws InitialisationException {
    }

    protected FtpMuleMessageFactory createMuleMessageFactory(FTPClient client) throws CreateException {
        FtpMuleMessageFactory factory = (FtpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setStreaming(this.connector.isStreaming());
        factory.setFtpClient(client);
        return factory;
    }

    protected void postProcess(FTPClient client, FTPFile file, MuleMessage message) throws Exception {
        if (!client.deleteFile(file.getName())) {
            throw new IOException(MessageFormat.format("Failed to delete file {0}. Ftp error: {1}", file.getName(), client.getReplyCode()));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted processed file " + file.getName()));
        }
        if (this.connector.isStreaming() && !client.completePendingCommand()) {
            throw new IOException(MessageFormat.format("Failed to complete a pending command. Retrieveing file {0}. Ftp error: {1}", file.getName(), client.getReplyCode()));
        }
    }

    protected void doConnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryContext validateConnection(RetryContext retryContext) {
        FTPClient client = null;
        try {
            client = this.connector.createFtpClient(this.endpoint);
            client.sendNoOp();
            client.logout();
            client.disconnect();
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed((Throwable)ex);
        }
        finally {
            block13: {
                try {
                    if (client != null) {
                        this.connector.releaseFtp(this.endpoint, client);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block13;
                    this.logger.debug((Object)("Failed to release ftp client " + client), (Throwable)e);
                }
            }
        }
        return retryContext;
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    private final class FtpWork
    implements Work {
        private final String name;
        private final FTPFile file;

        private FtpWork(String name, FTPFile file) {
            this.name = name;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            FTPClient client = null;
            MuleMessage muleMessage = null;
            Lock lock = FtpMessageReceiver.this.getEndpoint().getMuleContext().getLockFactory().createLock(this.file.getName());
            if (lock.tryLock()) {
                try {
                    MuleMessage finalMessage;
                    FTPClient finalClient = client = FtpMessageReceiver.this.connector.createFtpClient(FtpMessageReceiver.this.endpoint);
                    FtpMessageReceiver.this.currentFiles.add(this.name);
                    if (!FtpMessageReceiver.this.connector.validateFile(this.file)) {
                        return;
                    }
                    FtpMuleMessageFactory muleMessageFactory = FtpMessageReceiver.this.createMuleMessageFactory(finalClient);
                    muleMessage = finalMessage = muleMessageFactory.create(this.file, FtpMessageReceiver.this.endpoint.getEncoding(), FtpMessageReceiver.this.endpoint.getMuleContext());
                    ExecutionTemplate executionTemplate = FtpMessageReceiver.this.createExecutionTemplate();
                    executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                        public MuleEvent process() throws Exception {
                            FtpMessageReceiver.this.routeMessage(finalMessage);
                            return null;
                        }
                    });
                    FtpMessageReceiver.this.postProcess(finalClient, this.file, finalMessage);
                    return;
                }
                catch (MessagingException e) {
                    if (e.causedRollback()) return;
                    try {
                        FtpMessageReceiver.this.postProcess(client, this.file, muleMessage);
                        return;
                    }
                    catch (Exception e1) {
                        FtpMessageReceiver.this.logger.error((Object)e);
                    }
                    return;
                }
                catch (Exception e) {
                    FtpMessageReceiver.this.getEndpoint().getMuleContext().getExceptionListener().handleException(e);
                    return;
                }
                finally {
                    lock.unlock();
                    if (client != null) {
                        try {
                            FtpMessageReceiver.this.connector.releaseFtp(FtpMessageReceiver.this.endpoint, client);
                        }
                        catch (Exception e) {
                            FtpMessageReceiver.this.logger.error((Object)e);
                        }
                    }
                    FtpMessageReceiver.this.currentFiles.remove(this.name);
                    FtpMessageReceiver.this.scheduledFiles.remove(this.name);
                }
            }
            FtpMessageReceiver.this.scheduledFiles.remove(this.name);
        }

        public void release() {
        }
    }
}

