/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.AsyncMessageNotificationListener;
import org.mule.api.context.notification.ClusterNodeNotificationListener;
import org.mule.api.context.notification.ConnectionNotificationListener;
import org.mule.api.context.notification.CustomNotificationListener;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ManagementNotificationListener;
import org.mule.api.context.notification.ModelNotificationListener;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.PipelineMessageNotificationListener;
import org.mule.api.context.notification.RegistryNotificationListener;
import org.mule.api.context.notification.RoutingNotificationListener;
import org.mule.api.context.notification.SecurityNotificationListener;
import org.mule.api.context.notification.ServiceNotificationListener;
import org.mule.api.context.notification.TransactionNotificationListener;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.notification.AsyncMessageNotification;
import org.mule.context.notification.ClusterNodeNotification;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.CustomNotification;
import org.mule.context.notification.ExceptionNotification;
import org.mule.context.notification.ManagementNotification;
import org.mule.context.notification.ModelNotification;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.PipelineMessageNotification;
import org.mule.context.notification.RegistryNotification;
import org.mule.context.notification.RoutingNotification;
import org.mule.context.notification.SecurityNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.context.notification.ServiceNotification;
import org.mule.context.notification.TransactionNotification;
import org.mule.lifecycle.MuleContextLifecycleManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.work.MuleWorkManager;

public class DefaultMuleContextBuilderTestCase
extends AbstractMuleTestCase {
    @Test
    public void testBuildMuleContextDefault() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        MuleContext muleContext = builder.buildMuleContext();
        Assert.assertNotNull((Object)muleContext);
        Assert.assertEquals(DefaultMuleConfiguration.class, muleContext.getConfiguration().getClass());
        Assert.assertEquals(MuleContextLifecycleManager.class, muleContext.getLifecycleManager().getClass());
        Assert.assertEquals(ServerNotificationManager.class, muleContext.getNotificationManager().getClass());
        Assert.assertEquals(MuleWorkManager.class, muleContext.getWorkManager().getClass());
    }

    @Test
    public void testBuildMuleContextCustom() {
        MuleContext muleContext = this.build();
        Assert.assertNotNull((Object)muleContext);
        Assert.assertEquals(MyMuleConfiguration.class, muleContext.getConfiguration().getClass());
        Assert.assertEquals(MyLifeCycleManager.class, muleContext.getLifecycleManager().getClass());
        Assert.assertEquals(MyServerNotificationManager.class, muleContext.getNotificationManager().getClass());
        Assert.assertEquals(MyWorkManager.class, muleContext.getWorkManager().getClass());
    }

    @Test
    public void notificationManagerContainsTheCorrectInterfaces() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        builder.setMuleConfiguration((MuleConfiguration)new MyMuleConfiguration());
        builder.setLifecycleManager((LifecycleManager)new MyLifeCycleManager());
        builder.setWorkManager((WorkManager)new MyWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, "test"));
        MuleContext muleContext = builder.buildMuleContext();
        Map interfaces = muleContext.getNotificationManager().getInterfaceToTypes();
        Assert.assertEquals(MuleContextNotification.class, (Object)((Set)interfaces.get(MuleContextNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ModelNotification.class, (Object)((Set)interfaces.get(ModelNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(RoutingNotification.class, (Object)((Set)interfaces.get(RoutingNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ServiceNotification.class, (Object)((Set)interfaces.get(ServiceNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(SecurityNotification.class, (Object)((Set)interfaces.get(SecurityNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ManagementNotification.class, (Object)((Set)interfaces.get(ManagementNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(CustomNotification.class, (Object)((Set)interfaces.get(CustomNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ConnectionNotification.class, (Object)((Set)interfaces.get(ConnectionNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(RegistryNotification.class, (Object)((Set)interfaces.get(RegistryNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ExceptionNotification.class, (Object)((Set)interfaces.get(ExceptionNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(TransactionNotification.class, (Object)((Set)interfaces.get(TransactionNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(PipelineMessageNotification.class, (Object)((Set)interfaces.get(PipelineMessageNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(AsyncMessageNotification.class, (Object)((Set)interfaces.get(AsyncMessageNotificationListener.class)).toArray()[0]);
        Assert.assertEquals(ClusterNodeNotification.class, (Object)((Set)interfaces.get(ClusterNodeNotificationListener.class)).toArray()[0]);
    }

    private MuleContext build() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        builder.setMuleConfiguration((MuleConfiguration)new MyMuleConfiguration());
        builder.setLifecycleManager((LifecycleManager)new MyLifeCycleManager());
        builder.setNotificationManager((ServerNotificationManager)new MyServerNotificationManager());
        builder.setWorkManager((WorkManager)new MyWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, "test"));
        return builder.buildMuleContext();
    }

    protected MuleContext createMuleContext() throws Exception {
        return null;
    }

    static class MyWorkManager
    extends MuleWorkManager {
        public MyWorkManager(ThreadingProfile profile, String name) {
            super(profile, name, 5000);
        }
    }

    static class MyServerNotificationManager
    extends ServerNotificationManager {
        MyServerNotificationManager() {
        }
    }

    static class MyMuleConfiguration
    extends DefaultMuleConfiguration {
        MyMuleConfiguration() {
        }
    }

    static class MyLifeCycleManager
    extends MuleContextLifecycleManager {
        MyLifeCycleManager() {
        }
    }
}

