/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import com.google.common.base.Charsets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;
import org.apache.xmlbeans.impl.util.Base64;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityContext;
import org.mule.api.serialization.SerializationException;
import org.mule.session.DefaultMuleSession;
import org.mule.session.LegacySessionHandler;
import org.mule.session.SerializeAndEncodeSessionHandler;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@Ignore(value="This test has to be run alone, because the system property it sets invalidates the run of SerializeAndEncodeSessionHandlerTestCase afterwards")
public class MuleSessionHandlerTestCase
extends AbstractMuleTestCase {
    private static String originalEncoding;
    private MuleContext muleContext;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private SerializeAndEncodeSessionHandler handler;
    private DefaultMuleMessage message;
    @ClassRule
    public static SystemProperty sessionSignKey;

    @Before
    public void setUp() throws Exception {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration configuration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)configuration.getDefaultEncoding()).thenReturn((Object)Charsets.UTF_8.name());
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)this.muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        SerializationTestUtils.addJavaSerializerToMockMuleContext(this.muleContext);
        this.handler = new SerializeAndEncodeSessionHandler();
        this.message = new DefaultMuleMessage((Object)"Test Message", this.muleContext);
        this.message.setInboundProperty("MULE_ENDPOINT", (Object)"http://whatever");
    }

    @BeforeClass
    public static void setUpEncoding() {
        originalEncoding = System.getProperty("mule.encoding");
        System.setProperty("mule.encoding", "UTF-8");
    }

    @AfterClass
    public static void restoreEncoding() {
        if (originalEncoding == null) {
            System.clearProperty("mule.encoding");
        } else {
            System.setProperty("mule.encoding", originalEncoding);
        }
    }

    @Test
    public void testPrimitiveTypesInSessionProperties() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        int anInteger = 1;
        session.setProperty("anInteger", (Serializable)Integer.valueOf(anInteger));
        boolean aBoolean = true;
        session.setProperty("aBoolean", (Serializable)Boolean.valueOf(aBoolean));
        char aCharacter = 'a';
        session.setProperty("aCharacter", (Serializable)Character.valueOf(aCharacter));
        short aShort = 2;
        session.setProperty("aShort", (Serializable)Short.valueOf(aShort));
        long aLong = 3L;
        session.setProperty("aLong", (Serializable)Long.valueOf(aLong));
        float aFloat = 4.0f;
        session.setProperty("aFloat", (Serializable)Float.valueOf(aFloat));
        double aDouble = 5.0;
        session.setProperty("aDouble", (Serializable)Double.valueOf(aDouble));
        this.handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)this.message);
        Object s = this.message.removeProperty("MULE_SESSION");
        this.message.setInboundProperty("MULE_SESSION", s);
        Object obj = session.getProperty("anInteger");
        Assert.assertTrue((boolean)(obj instanceof Integer));
        Assert.assertEquals((Object)obj, (Object)anInteger);
        obj = session.getProperty("aBoolean");
        Assert.assertTrue((boolean)(obj instanceof Boolean));
        Assert.assertEquals((Object)obj, (Object)aBoolean);
        obj = session.getProperty("aCharacter");
        Assert.assertTrue((boolean)(obj instanceof Character));
        Assert.assertEquals((Object)obj, (Object)Character.valueOf(aCharacter));
        obj = session.getProperty("aShort");
        Assert.assertTrue((boolean)(obj instanceof Short));
        Assert.assertEquals((Object)obj, (Object)aShort);
        obj = session.getProperty("aLong");
        Assert.assertTrue((boolean)(obj instanceof Long));
        Assert.assertEquals((Object)obj, (Object)aLong);
        obj = session.getProperty("aFloat");
        Assert.assertTrue((boolean)(obj instanceof Float));
        Assert.assertEquals((Object)obj, (Object)Float.valueOf(aFloat));
        obj = session.getProperty("aDouble");
        Assert.assertTrue((boolean)(obj instanceof Double));
        Assert.assertEquals((Object)obj, (Object)aDouble);
    }

    @Test
    public void testPrimitiveWrappersInSessionProperties() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        Integer anInteger = 1;
        session.setProperty("anInteger", (Serializable)anInteger);
        Boolean aBoolean = true;
        session.setProperty("aBoolean", (Serializable)aBoolean);
        Character aCharacter = Character.valueOf('a');
        session.setProperty("aCharacter", (Serializable)aCharacter);
        Short aShort = 2;
        session.setProperty("aShort", (Serializable)aShort);
        Long aLong = 3L;
        session.setProperty("aLong", (Serializable)aLong);
        Float aFloat = Float.valueOf(4.0f);
        session.setProperty("aFloat", (Serializable)aFloat);
        Double aDouble = 5.0;
        session.setProperty("aDouble", (Serializable)aDouble);
        this.handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)this.message);
        Object s = this.message.removeProperty("MULE_SESSION");
        this.message.setInboundProperty("MULE_SESSION", s);
        Object obj = session.getProperty("anInteger");
        Assert.assertTrue((boolean)(obj instanceof Integer));
        Assert.assertEquals((Object)obj, (Object)anInteger);
        obj = session.getProperty("aBoolean");
        Assert.assertTrue((boolean)(obj instanceof Boolean));
        Assert.assertEquals((Object)obj, (Object)aBoolean);
        obj = session.getProperty("aCharacter");
        Assert.assertTrue((boolean)(obj instanceof Character));
        Assert.assertEquals((Object)obj, (Object)aCharacter);
        obj = session.getProperty("aShort");
        Assert.assertTrue((boolean)(obj instanceof Short));
        Assert.assertEquals((Object)obj, (Object)aShort);
        obj = session.getProperty("aLong");
        Assert.assertTrue((boolean)(obj instanceof Long));
        Assert.assertEquals((Object)obj, (Object)aLong);
        obj = session.getProperty("aFloat");
        Assert.assertTrue((boolean)(obj instanceof Float));
        Assert.assertEquals((Object)obj, (Object)aFloat);
        obj = session.getProperty("aDouble");
        Assert.assertTrue((boolean)(obj instanceof Double));
        Assert.assertEquals((Object)obj, (Object)aDouble);
    }

    @Test
    public void testNonPrimitiveAllowedSessionProperties() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        Date date = new Date(0L);
        session.setProperty("fooDate", (Serializable)date);
        this.handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)this.message);
        Object s = this.message.removeProperty("MULE_SESSION");
        this.message.setInboundProperty("MULE_SESSION", s);
        session = this.handler.retrieveSessionInfoFromMessage((MuleMessage)this.message);
        Object obj = session.getProperty("fooDate");
        Assert.assertTrue((String)("Object should be a Date but is " + obj.getClass().getName()), (boolean)(obj instanceof Date));
        Assert.assertEquals((Object)date, (Object)obj);
    }

    @Test
    public void testNullSessionProperty() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        Serializable nullString = null;
        session.setProperty("nullstr", nullString);
        this.handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)this.message);
        Object s = this.message.removeProperty("MULE_SESSION");
        this.message.setInboundProperty("MULE_SESSION", s);
        session = this.handler.retrieveSessionInfoFromMessage((MuleMessage)this.message);
        Object obj = session.getProperty("nullstr");
        Assert.assertEquals(nullString, (Object)obj);
    }

    @Test
    public void testSessionProperties() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        String string = "bar";
        session.setProperty("fooString", (Serializable)((Object)string));
        int nativeInteger = 1;
        session.setProperty("nativeInteger", (Serializable)Integer.valueOf(nativeInteger));
        Integer wrappedInteger = 2;
        session.setProperty("wrappedInteger", (Serializable)wrappedInteger);
        Date date = new Date(0L);
        session.setProperty("fooDate", (Serializable)date);
        this.handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)this.message);
        Object s = this.message.removeProperty("MULE_SESSION");
        this.message.setInboundProperty("MULE_SESSION", s);
        session = this.handler.retrieveSessionInfoFromMessage((MuleMessage)this.message);
        Object obj = session.getProperty("fooString");
        Assert.assertTrue((boolean)(obj instanceof String));
        Assert.assertEquals((Object)string, (Object)obj);
        obj = session.getProperty("nativeInteger");
        Assert.assertTrue((boolean)(obj instanceof Integer));
        Assert.assertEquals((Object)obj, (Object)1);
        obj = session.getProperty("wrappedInteger");
        Assert.assertTrue((boolean)(obj instanceof Integer));
        Assert.assertEquals((Object)obj, (Object)2);
        obj = session.getProperty("fooDate");
        Assert.assertTrue((String)("Object should be a Date but is " + obj.getClass().getName()), (boolean)(obj instanceof Date));
        Assert.assertEquals((Object)date, (Object)obj);
    }

    @Test
    public void testDontDeserializeOtherThanMuleSession() throws MuleException {
        String encodedSet = new String(Base64.encode((byte[])SerializationUtils.serialize(new HashSet())));
        this.message.setInboundProperty("MULE_SESSION", (Object)encodedSet);
        MuleSession session = this.handler.retrieveSessionInfoFromMessage((MuleMessage)this.message);
        Assert.assertNull((Object)session);
    }

    @Test
    public void testNonSerializableSessionProperties() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        NotSerializableClass clazz = new NotSerializableClass();
        session.setProperty("foo", (Object)clazz);
        this.handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)this.message);
        Object s = this.message.removeProperty("MULE_SESSION");
        this.message.setInboundProperty("MULE_SESSION", s);
        session = this.handler.retrieveSessionInfoFromMessage((MuleMessage)this.message);
        Assert.assertNull((Object)session.getProperty("foo"));
    }

    @Test
    public void testBackwardsCompatibility() throws Exception {
        LegacySessionHandler legacyHandler = new LegacySessionHandler();
        DefaultMuleSession session = new DefaultMuleSession();
        String string = "bar";
        session.setProperty("fooString", (Serializable)((Object)string));
        Date date = new Date(0L);
        session.setProperty("fooDate", (Serializable)date);
        List<String> list = this.createList();
        session.setProperty("fooList", list);
        legacyHandler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)this.message);
        try {
            session = new SerializeAndEncodeSessionHandler().retrieveSessionInfoFromMessage((MuleMessage)this.message);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        session = legacyHandler.retrieveSessionInfoFromMessage((MuleMessage)this.message);
    }

    @Test
    public void testSessionPropertiesLegacyFormat() throws Exception {
        LegacySessionHandler handler = new LegacySessionHandler();
        DefaultMuleSession session = new DefaultMuleSession();
        String string = "bar";
        session.setProperty("fooString", (Serializable)((Object)string));
        Date date = new Date(0L);
        session.setProperty("fooDate", (Serializable)date);
        List<String> list = this.createList();
        session.setProperty("fooList", list);
        handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)this.message);
        Object s = this.message.removeProperty("MULE_SESSION");
        this.message.setInboundProperty("MULE_SESSION", s);
        session = handler.retrieveSessionInfoFromMessage((MuleMessage)this.message);
        Object obj = session.getProperty("fooString");
        Assert.assertTrue((boolean)(obj instanceof String));
        Assert.assertEquals((Object)string, (Object)obj);
        obj = session.getProperty("fooDate");
        Assert.assertTrue((boolean)(obj instanceof String));
        obj = session.getProperty("fooList");
        Assert.assertTrue((boolean)(obj instanceof String));
    }

    private List<String> createList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("bar1");
        list.add("bar2");
        return list;
    }

    static {
        sessionSignKey = new SystemProperty("mule.session.serialization.native.enable", "true");
    }

    private class NotSerializableSecurityContext
    implements SecurityContext {
        public void setAuthentication(Authentication authentication) {
        }

        public Authentication getAuthentication() {
            return null;
        }
    }

    private class NotSerializableClass {
    }
}

