/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.context.notification.MessageProcessingFlowTraceManager;
import org.mule.context.notification.ServerNotificationManager;

public class FlowTraceManagerReinitializeTestCase {
    private MessageProcessingFlowTraceManager manager;
    private static boolean originalFlowTrace;

    @BeforeClass
    public static void beforeClass() {
        originalFlowTrace = DefaultMuleConfiguration.flowTrace;
        DefaultMuleConfiguration.flowTrace = true;
    }

    @AfterClass
    public static void afterClass() {
        DefaultMuleConfiguration.flowTrace = originalFlowTrace;
    }

    @Before
    public void before() throws InitialisationException {
        this.manager = new MessageProcessingFlowTraceManager();
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration config = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)config);
        Mockito.when((Object)context.getNotificationManager()).thenReturn((Object)new ServerNotificationManager());
        this.manager.setMuleContext(context);
        this.manager.initialise();
    }

    @Test
    public void reinitializeDoesntRemoveListeners() throws InitialisationException {
        this.manager = (MessageProcessingFlowTraceManager)Mockito.spy((Object)this.manager);
        this.manager.initialise();
        ((MessageProcessingFlowTraceManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).removeNotificationListeners();
    }
}

