/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.el.mvel.DelegateVariableResolverFactory;
import org.mule.el.mvel.GlobalVariableResolverFactory;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.el.mvel.MessageVariableResolverFactory;
import org.mule.el.mvel.StaticVariableResolverFactory;
import org.mule.el.mvel.VariableVariableResolverFactory;
import org.mule.el.mvel.datatype.ExpressionDataTypeResolver;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.CachedMapVariableResolverFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;

public abstract class AbstractVarExpressionDataTypeResolverTestCase
extends AbstractMuleContextTestCase {
    public static final String EXPRESSION_VALUE = "bar";
    public static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    public static final String PROPERTY_NAME = "foo";
    private final ExpressionDataTypeResolver expressionDataTypeResolver;
    private final PropertyScope scope;
    private final String variableName;

    protected AbstractVarExpressionDataTypeResolverTestCase(ExpressionDataTypeResolver expressionDataTypeResolver, PropertyScope scope, String variableName) {
        this.expressionDataTypeResolver = expressionDataTypeResolver;
        this.scope = scope;
        this.variableName = variableName;
    }

    @Test
    public void returnsFlowVarDataTypeUsingMapSyntax() throws Exception {
        this.doVarDataTypeTest(this.variableName + "['" + PROPERTY_NAME + "']");
    }

    @Test
    public void returnsFlowVarDataTypeUsingDotSyntax() throws Exception {
        this.doVarDataTypeTest(this.variableName + "." + PROPERTY_NAME);
    }

    @Test
    public void returnsFlowVarDataTypeUsingEscapedDotSyntax() throws Exception {
        this.doVarDataTypeTest(this.variableName + ".'" + PROPERTY_NAME + "'");
    }

    protected void doVarDataTypeTest(String expression) throws Exception {
        DataType expectedDataType = DataTypeFactory.create(String.class, (String)"text/json");
        expectedDataType.setEncoding(CUSTOM_ENCODING);
        MuleEvent testEvent = AbstractVarExpressionDataTypeResolverTestCase.getTestEvent("Test Message");
        testEvent.getMessage().setProperty(PROPERTY_NAME, (Object)EXPRESSION_VALUE, this.scope, expectedDataType);
        ParserConfiguration parserConfiguration = MVELExpressionLanguage.createParserConfiguration((Map)Collections.EMPTY_MAP);
        MVELExpressionLanguageContext context = this.createMvelExpressionLanguageContext(testEvent, parserConfiguration);
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(parserConfiguration));
        MVEL.executeExpression((Object)compiledExpression, (VariableResolverFactory)context);
        MatcherAssert.assertThat((Object)this.expressionDataTypeResolver.resolve(testEvent.getMessage(), compiledExpression), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }

    protected MVELExpressionLanguageContext createMvelExpressionLanguageContext(MuleEvent testEvent, ParserConfiguration parserConfiguration) {
        MVELExpressionLanguageContext context = new MVELExpressionLanguageContext(parserConfiguration, muleContext);
        StaticVariableResolverFactory staticContext = new StaticVariableResolverFactory(parserConfiguration, muleContext);
        GlobalVariableResolverFactory globalContext = new GlobalVariableResolverFactory(Collections.EMPTY_MAP, Collections.EMPTY_MAP, parserConfiguration, muleContext);
        context.setNextFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(Collections.EMPTY_MAP, (VariableResolverFactory)new DelegateVariableResolverFactory((VariableResolverFactory)staticContext, (VariableResolverFactory)new MessageVariableResolverFactory(parserConfiguration, muleContext, testEvent.getMessage(), (VariableResolverFactory)new DelegateVariableResolverFactory((VariableResolverFactory)globalContext, (VariableResolverFactory)new VariableVariableResolverFactory(parserConfiguration, muleContext, testEvent))))));
        return context;
    }
}

