/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.tck.testmodels.mule.TestMessageProcessor;

public class OutboundEndpointMessageProcessorsTestCase
extends AbstractMessageProcessorTestCase {
    private MuleEvent testOutboundEvent;
    private OutboundEndpoint endpoint;
    private MuleEvent result;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
    }

    @Test
    public void testProcessors() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestMessageProcessor("1"), new TestMessageProcessor("2"), new TestMessageProcessor("3")});
        MessageProcessorChain mpChain = builder.build();
        this.result = mpChain.process(this.testOutboundEvent);
        Assert.assertEquals((Object)"Test Message:1:2:3", (Object)this.result.getMessage().getPayload());
    }

    @Test
    public void testNoProcessors() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain mpChain = builder.build();
        this.result = mpChain.process(this.testOutboundEvent);
        Assert.assertEquals((Object)"Test Message", (Object)this.result.getMessage().getPayload());
    }

    protected OutboundEndpoint createOutboundEndpoint(Filter filter, EndpointSecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        return this.createTestOutboundEndpoint(filter, securityFilter, in, response, exchangePattern, txConfig);
    }
}

