/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transport.ConnectException;
import org.mule.transport.ConnectorLifecycleManager;

public class DefaultSystemExceptionStrategyTestCase
extends AbstractMuleContextTestCase {
    private FailureStopConnector connector;
    private final ConnectorLifecycleManager lifecycleManager = (ConnectorLifecycleManager)Mockito.mock(ConnectorLifecycleManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final ConnectException connectException = (ConnectException)Mockito.mock(ConnectException.class);
    private DefaultSystemExceptionStrategy exceptionStrategy;

    @Before
    public void setUp() throws Exception {
        this.connector = new FailureStopConnector(muleContext, this.lifecycleManager);
        this.connector.setConnecting(false);
        this.connector.setConnected(true);
        this.exceptionStrategy = new DefaultSystemExceptionStrategy(muleContext);
        Mockito.when((Object)this.connectException.getStackTrace()).thenReturn((Object)new StackTraceElement[0]);
        Mockito.when((Object)this.connectException.getFailed()).thenReturn((Object)this.connector);
        ((ConnectorLifecycleManager)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws MuleException {
                LifecycleCallback lifecycleCallback = (LifecycleCallback)invocation.getArguments()[0];
                lifecycleCallback.onTransition("stop", (Object)DefaultSystemExceptionStrategyTestCase.this.connector);
                return null;
            }
        }).when((Object)this.lifecycleManager)).fireStopPhase((LifecycleCallback)Matchers.any());
        Mockito.when((Object)this.lifecycleManager.getState().isStarted()).thenReturn((Object)false);
    }

    @Test
    public void disconnectionIsAlwaysExecutedInReconnection() {
        this.exceptionStrategy.handleException((Exception)this.connectException);
        Assert.assertThat((Object)this.connector.isConnected(), (Matcher)Is.is((Object)false));
    }

    private static class FailureStopConnector
    extends TestConnector {
        FailureStopConnector(MuleContext context, ConnectorLifecycleManager lifecycleManager) {
            super(context);
            this.lifecycleManager = lifecycleManager;
        }

        @Override
        protected void doStop() {
            throw new RuntimeException("Test exception");
        }
    }
}

