/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.exception.TemplateMessagingExceptionStrategy;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class TemplateMessagingExceptionStrategyTestCase
extends AbstractMuleContextTestCase {
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    @Mock
    private Exception mockException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleMessage mockMuleMessage;
    @Mock
    private FlowConstruct mockFlowConstruct;
    @Mock
    private FlowConstructStatistics mockStatistics;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected MuleContext muleContext;

    public TemplateMessagingExceptionStrategy createExceptionStrategy() throws Exception {
        TestMessagingExceptionStrategyTestCase messagingExceptionStrategy = new TestMessagingExceptionStrategyTestCase();
        messagingExceptionStrategy.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.mockMuleMessage);
        Mockito.when((Object)this.mockMuleEvent.getFlowConstruct()).thenReturn((Object)this.mockFlowConstruct);
        Mockito.when((Object)this.mockFlowConstruct.getStatistics()).thenReturn((Object)this.mockStatistics);
        Mockito.when((Object)this.mockStatistics.isEnabled()).thenReturn((Object)true);
        return messagingExceptionStrategy;
    }

    @Test
    public void statisticsErrorCountIncreaseByDefault() throws Exception {
        this.testErrorCount(false, false, 1);
        this.testErrorCount(false, true, 2);
    }

    @Test
    public void statisticsErrorCountDoesNotIncreaseIfDisableErrorCountAndErrorNotificationDisabled() throws Exception {
        this.testErrorCount(true, false, 0);
    }

    public void statisticsErrorCountDoesIncreaseIfDisableErrorCountAndErrorNotificationEnabled() throws Exception {
        this.testErrorCount(false, true, 1);
    }

    private void testErrorCount(Boolean disableErrorCount, boolean enableNotifications, int expectedExcecutionErrorCount) throws Exception {
        System.setProperty("mule.disable.error.count.on.error.notifications.disabled", disableErrorCount.toString());
        TemplateMessagingExceptionStrategy messagingExceptionStrategy = this.createExceptionStrategy();
        messagingExceptionStrategy.setEnableNotifications(enableNotifications);
        messagingExceptionStrategy.handleException(this.mockException, this.mockMuleEvent);
        ((FlowConstructStatistics)Mockito.verify((Object)this.mockStatistics, (VerificationMode)Mockito.times((int)expectedExcecutionErrorCount))).incExecutionError();
    }

    private static class TestMessagingExceptionStrategyTestCase
    extends TemplateMessagingExceptionStrategy {
        private TestMessagingExceptionStrategyTestCase() {
        }
    }
}

