/*
 * Decompiled with CFR 0.152.
 */
package org.mule.interceptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.Component;
import org.mule.api.service.Service;
import org.mule.api.transport.ReplyToHandler;
import org.mule.component.AbstractComponent;
import org.mule.interceptor.AbstractEnvelopeInterceptor;
import org.mule.interceptor.InterceptorStack;
import org.mule.management.stats.ProcessingTime;
import org.mule.model.seda.SedaService;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=Parameterized.class)
public class InterceptorTestCase
extends AbstractMuleContextTestCase {
    private final String BEFORE = "Before";
    private final String AFTER = "After";
    private final String COMPONENT = "component";
    private final String INTERCEPTOR_ONE = "inteceptor1";
    private final String INTERCEPTOR_TWO = "inteceptor2";
    private final String INTERCEPTOR_THREE = "inteceptor3";
    private final String SINGLE_INTERCEPTOR_RESULT = "inteceptor1Beforecomponentinteceptor1After";
    private final String MULTIPLE_INTERCEPTOR_RESULT = "inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After";
    private Factory testEventFactory;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new Factory(){

            public Object create() {
                try {
                    return AbstractMuleContextTestCase.getTestEvent("");
                }
                catch (Exception e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
        }}, {new Factory(){

            public Object create() {
                try {
                    return InterceptorTestCase.getNonBlockingTestEventUsingFlow("", (ReplyToHandler)Mockito.mock(ReplyToHandler.class));
                }
                catch (Exception e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
        }});
    }

    public InterceptorTestCase(Factory testEventFactory) {
        this.testEventFactory = testEventFactory;
    }

    @Test
    public void testSingleInterceptor() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process((MuleEvent)this.testEventFactory.create());
        Assert.assertEquals((Object)"inteceptor1Beforecomponentinteceptor1After", (Object)result.getMessageAsString());
    }

    @Test
    public void testMultipleInterceptor() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new TestInterceptor("inteceptor2"));
        interceptors.add(new TestInterceptor("inteceptor3"));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process((MuleEvent)this.testEventFactory.create());
        Assert.assertEquals((Object)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After", (Object)result.getMessageAsString());
    }

    @Test
    public void testSingleInterceptorStack() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<InterceptorStack> interceptors = new ArrayList<InterceptorStack>();
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process((MuleEvent)this.testEventFactory.create());
        Assert.assertEquals((Object)"inteceptor1Beforecomponentinteceptor1After", (Object)result.getMessageAsString());
    }

    @Test
    public void testMultipleInterceptorStack() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor2"));
        stackInterceptors.add(new TestInterceptor("inteceptor3"));
        interceptors.add((TestInterceptor)new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process((MuleEvent)this.testEventFactory.create());
        Assert.assertEquals((Object)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After", (Object)result.getMessageAsString());
    }

    @Test
    public void testMultipleInterceptorStack2() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new TestInterceptor("inteceptor2"));
        interceptors.add(new TestInterceptor("inteceptor3"));
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor1"));
        stackInterceptors.add(new TestInterceptor("inteceptor2"));
        stackInterceptors.add(new TestInterceptor("inteceptor3"));
        interceptors.add((TestInterceptor)new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process((MuleEvent)this.testEventFactory.create());
        Assert.assertEquals((Object)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforeinteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1Afterinteceptor3Afterinteceptor2Afterinteceptor1After", (Object)result.getMessageAsString());
    }

    protected Service createUninitializedService() throws Exception {
        TestComponent component = new TestComponent();
        SedaService service = new SedaService(muleContext);
        service.setName("name");
        service.setComponent((Component)component);
        service.setModel(muleContext.getRegistry().lookupSystemModel());
        return service;
    }

    class TestComponent
    extends AbstractComponent {
        TestComponent() {
        }

        protected Object doInvoke(MuleEvent event) throws Exception {
            return event.getMessageAsString() + "component";
        }
    }

    class TestInterceptor
    extends AbstractEnvelopeInterceptor {
        private String name;

        public TestInterceptor(String name) {
            this.name = name;
        }

        public MuleEvent after(MuleEvent event) {
            try {
                event.getMessage().setPayload((Object)(event.getMessage().getPayloadAsString() + this.name + "After"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            return event;
        }

        public MuleEvent before(MuleEvent event) {
            try {
                event.getMessage().setPayload((Object)(event.getMessage().getPayloadAsString() + this.name + "Before"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            return event;
        }

        public MuleEvent last(MuleEvent event, ProcessingTime time, long startTime, boolean exceptionWasThrown) throws MuleException {
            return event;
        }
    }
}

