/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.context.WorkManager;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicy;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transport.Connector;
import org.mule.management.stats.AllStatistics;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.retry.PolicyStatus;
import org.mule.retry.RetryPolicyExhaustedException;
import org.mule.retry.policies.AbstractPolicyTemplate;

public class ConnectionErrorStatisticsTestCase {
    private MuleRegistry muleRegistry;
    private MuleContext muleContext;

    @Before
    public void setUp() throws Exception {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        TestAllStatistics allStatistics = new TestAllStatistics();
        allStatistics.setEnabled(true);
        Mockito.when((Object)this.muleContext.getStatistics()).thenReturn((Object)allStatistics);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
    }

    @Test
    public void connectionErrorsAreComputedAsExecutionErrors() throws Exception {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        RetryPolicyTemplate retryPolicyTemplate = this.addConnectorWithRetryPolicy(connectors);
        RetryCallback callback = (RetryCallback)Mockito.mock(RetryCallback.class);
        WorkManager workManager = (WorkManager)Mockito.mock(WorkManager.class);
        ((RetryCallback)Mockito.doThrow((Throwable)new Exception("Failure to connect")).when((Object)callback)).doWork((RetryContext)org.mockito.Matchers.any(RetryContext.class));
        try {
            retryPolicyTemplate.execute(callback, workManager);
        }
        catch (RetryPolicyExhaustedException retryPolicyExhaustedException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.muleContext.getStatistics().getApplicationStatistics().getConnectionErrors(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertThat((Object)this.muleContext.getStatistics().getApplicationStatistics().getExecutionErrors(), (Matcher)Matchers.equalTo((Object)1L));
    }

    private RetryPolicyTemplate addConnectorWithRetryPolicy(List<Connector> connectors) {
        Connector connector = (Connector)Mockito.mock(Connector.class);
        connectors.add(connector);
        RetryPolicy retryPolicy = (RetryPolicy)Mockito.mock(RetryPolicy.class);
        PolicyStatus policyStatus = (PolicyStatus)Mockito.mock(PolicyStatus.class);
        TestRetryPolicyTemplate retryPolicyTemplate = new TestRetryPolicyTemplate(retryPolicy);
        retryPolicyTemplate.setMuleContext(this.muleContext);
        Mockito.when((Object)policyStatus.isOk()).thenReturn((Object)false);
        Mockito.when((Object)retryPolicy.applyPolicy((Throwable)Mockito.any(Throwable.class))).thenReturn((Object)policyStatus);
        Mockito.when((Object)connector.getRetryPolicyTemplate()).thenReturn((Object)retryPolicyTemplate);
        return retryPolicyTemplate;
    }

    private static class TestAllStatistics
    extends AllStatistics {
        private TestAllStatistics() {
        }

        public synchronized void add(FlowConstructStatistics stats) {
            stats.setComputeConnectionErrors(true);
            super.add(stats);
        }
    }

    private static class TestRetryPolicyTemplate
    extends AbstractPolicyTemplate {
        private RetryPolicy retryPolicy;

        public TestRetryPolicyTemplate(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
        }

        public RetryPolicy createRetryInstance() {
            return this.retryPolicy;
        }
    }
}

