/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.enricher;

import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.api.transport.ReplyToHandler;
import org.mule.construct.Flow;
import org.mule.enricher.MessageEnricher;
import org.mule.processor.chain.DefaultMessageProcessorChain;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.SensingNullReplyToHandler;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;

public abstract class AbstractEnricherTestCase
extends AbstractMuleContextTestCase {
    public static final String FOO_FLOW_VAR_EXPRESSION = "#[flowVars['foo']]";

    protected MuleEvent createNonBlockingEvent(SensingNullReplyToHandler nullReplyToHandler) {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getProcessorPath((MessageProcessor)Matchers.any(MessageProcessor.class))).thenReturn((Object)"testPath");
        Mockito.when((Object)flow.getProcessingStrategy()).thenReturn((Object)new NonBlockingProcessingStrategy());
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext), MessageExchangePattern.REQUEST_RESPONSE, (ReplyToHandler)nullReplyToHandler, (FlowConstruct)flow);
    }

    protected MuleEvent createBlockingEvent() {
        return this.createNonBlockingEvent(null);
    }

    protected MessageEnricher createEnricher(SensingNullMessageProcessor sensingNullMessageProcessor) {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[sessionVars['foo']]"));
        enricher.setEnrichmentMessageProcessor((MessageProcessor)sensingNullMessageProcessor);
        return enricher;
    }

    protected MuleEvent processEnricherInChain(MessageEnricher enricher, final MuleEvent in) throws MuleException {
        return DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{enricher, new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                ((ThreadSafeAccess)event).assertAccess(true);
                Assert.assertThat((Object)event.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)in.getMessage())));
                return event;
            }
        }}).process(in);
    }

    protected void doEnrichDataTypePropagationTest(MessageEnricher.EnrichExpressionPair pair) throws Exception {
        final DataType dataType = DataTypeFactory.create(String.class, (String)"text/json");
        dataType.setEncoding(StandardCharsets.UTF_16.name());
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(pair);
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"bar", dataType);
                return event;
            }
        });
        MuleEvent in = AbstractEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getInvocationProperty("foo"));
        Assert.assertThat((Object)out.getMessage().getPropertyDataType("foo", PropertyScope.INVOCATION), DataTypeMatcher.like(String.class, "text/json", StandardCharsets.UTF_16.name()));
    }
}

