/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.enricher;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.enricher.MessageEnricher;
import org.mule.mule.enricher.AbstractEnricherTestCase;
import org.mule.tck.SensingNullMessageProcessor;

public class MessageEnricherWithNotificationTestCase
extends AbstractEnricherTestCase {
    @BeforeClass
    public static void before() {
        System.setProperty("mule.handle.copy.event.for.notification", "true");
    }

    @Test
    public void testRaceConditionBetweenEnricherAndNotificationListener() throws Exception {
        muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        muleContext.getNotificationManager().addListener((ServerNotificationListener)new MessageProcessorNotificationListener(){

            public void onNotification(ServerNotification notification) {
                if (1601 == notification.getAction()) {
                    final ThreadSafeAccess event = (ThreadSafeAccess)notification.getSource();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (true) {
                                event.resetAccessControl();
                            }
                        }
                    }).start();
                }
            }
        });
        MessageEnricher enricher = this.createEnricher(new SensingNullMessageProcessor());
        MuleEvent in = this.createBlockingEvent();
        try {
            this.processEnricherInChain(enricher, in);
        }
        catch (Exception e) {
            Assert.fail((String)"Enricher has lost the ownership of the thread");
        }
    }
}

