/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transaction.TransactionConfig;
import org.mule.processor.EndpointTransactionalInterceptingMessageProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class EndpointTransactionalInterceptingMessageProcessorTestCase
extends AbstractMuleTestCase {
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private EndpointTransactionalInterceptingMessageProcessor processor;
    private MessageProcessor next = (MessageProcessor)Mockito.mock(MessageProcessor.class);
    private TransactionConfig config = (TransactionConfig)Mockito.mock(TransactionConfig.class);
    private MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);

    @Before
    public void setup() {
        this.processor = new EndpointTransactionalInterceptingMessageProcessor(this.config);
        this.processor.setMuleContext(this.mockMuleContext);
        this.processor.setListener(this.next);
        Mockito.when((Object)this.event.getMuleContext()).thenReturn((Object)this.mockMuleContext);
        Mockito.when((Object)this.config.isInteractWithExternal()).thenReturn((Object)true);
    }

    @Test
    public void executesNextIfTransactionIsConfigured() throws MuleException {
        Mockito.when((Object)this.config.isConfigured()).thenReturn((Object)true);
        this.processor.process(this.event);
        ((MessageProcessor)Mockito.verify((Object)this.next)).process((MuleEvent)Matchers.any(MuleEvent.class));
    }

    @Test
    public void executesNextIfTransactionIsNotConfigured() throws MuleException {
        Mockito.when((Object)this.config.isConfigured()).thenReturn((Object)false);
        this.processor.process(this.event);
        ((MessageProcessor)Mockito.verify((Object)this.next)).process((MuleEvent)Matchers.any(MuleEvent.class));
    }

    @Test
    public void usesTransactionConfigurationWhenConfigured() throws MuleException {
        Mockito.when((Object)this.config.isConfigured()).thenReturn((Object)true);
        this.processor.process(this.event);
        ((TransactionConfig)Mockito.verify((Object)this.config)).getFactory();
    }

    @Test
    public void doesntUseTransactionConfigurationWhenConfigured() throws MuleException {
        Mockito.when((Object)this.config.isConfigured()).thenReturn((Object)false);
        this.processor.process(this.event);
        ((TransactionConfig)Mockito.verify((Object)this.config, (VerificationMode)Mockito.never())).getFactory();
    }
}

