/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry.policies;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.retry.RetryPolicy;
import org.mule.retry.PolicyStatus;
import org.mule.retry.policies.AbstractPolicyTemplate;

public class AbstractPolicyTemplateTestCase {
    private AbstractPolicyTemplate abstractPolicyTemplate;
    private RetryPolicy retryPolicy;
    private RetryCallback retryCallback;
    private WorkManager workManager;
    private RetryNotifier retryNotifier;

    @Before
    public void setUp() throws Exception {
        this.retryPolicy = (RetryPolicy)Mockito.mock(RetryPolicy.class);
        this.abstractPolicyTemplate = new AbstractPolicyTemplate(){

            public RetryPolicy createRetryInstance() {
                return AbstractPolicyTemplateTestCase.this.retryPolicy;
            }
        };
        this.retryNotifier = (RetryNotifier)Mockito.mock(RetryNotifier.class);
        this.abstractPolicyTemplate.setNotifier(this.retryNotifier);
        this.retryCallback = (RetryCallback)Mockito.mock(RetryCallback.class);
        this.workManager = (WorkManager)Mockito.mock(WorkManager.class);
    }

    @Test
    public void testCancelStart() {
        MatcherAssert.assertThat((Object)this.abstractPolicyTemplate.isStopRetrying().get(), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
        this.abstractPolicyTemplate.stopRetrying();
        MatcherAssert.assertThat((Object)this.abstractPolicyTemplate.isStopRetrying().get(), (Matcher)org.hamcrest.Matchers.equalTo((Object)true));
    }

    @Test
    public void executeCanceledStart() throws Exception {
        ((RetryCallback)Mockito.doThrow((Throwable)new Exception()).when((Object)this.retryCallback)).doWork((RetryContext)Matchers.any(RetryContext.class));
        Mockito.when((Object)this.retryPolicy.applyPolicy((Throwable)Matchers.any(Throwable.class))).thenReturn((Object)PolicyStatus.policyOk());
        this.abstractPolicyTemplate.stopRetrying();
        this.abstractPolicyTemplate.execute(this.retryCallback, this.workManager);
    }
}

