/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.MuleConfiguration;
import org.mule.routing.MessageSequence;
import org.mule.routing.outbound.AbstractMessageSequenceSplitter;
import org.mule.tck.junit4.rule.SystemProperty;

public class AbstractMessageSequenceSplitterTestCase {
    @ClassRule
    public static SystemProperty compoundCorrelationIdDisable = new SystemProperty("mule.compoundCorrelationId.disable", "false");
    private AbstractMessageSequenceSplitter abstractMessageSequenceSplitter;
    private MuleMessage message;
    private boolean isSequential = false;

    @Before
    public void setUp() {
        String someObject = "Hello";
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration configuration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)configuration.getDefaultEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)configuration);
        this.message = new DefaultMuleMessage(someObject, muleContext){};
        this.abstractMessageSequenceSplitter = new AbstractMessageSequenceSplitter(){

            protected MessageSequence<?> splitMessageIntoSequence(MuleEvent event) throws MuleException {
                return null;
            }

            protected boolean isSequential() {
                return AbstractMessageSequenceSplitterTestCase.this.isSequential;
            }
        };
    }

    @Test
    public void testSetMessageCorrelationIdIsSequentialSetsMessageCorrelationIdAsIs_WhenCompoundCorrelationIdIsNotDisabled() {
        this.isSequential = true;
        String correlationId = "Jack";
        int correlationSequence = 1;
        this.abstractMessageSequenceSplitter.setMessageCorrelationId(this.message, correlationId, correlationSequence);
        MatcherAssert.assertThat((String)"Correlation Id is not as expected", (Object)this.message.getCorrelationId(), (Matcher)CoreMatchers.is((Object)correlationId));
    }

    @Test
    public void testSetMessageCorrelationIdIsNotSequentialSetsMessageCorrelationIdAsIs_WhenCompoundCorrelationIdIsNotDisabled() {
        this.isSequential = false;
        String correlationId = "Jack";
        int correlationSequence = 1;
        this.abstractMessageSequenceSplitter.setMessageCorrelationId(this.message, correlationId, correlationSequence);
        MatcherAssert.assertThat((String)"Correlation Id is not as expected", (Object)this.message.getCorrelationId(), (Matcher)CoreMatchers.is((Object)correlationId));
    }
}

