/*
 * Decompiled with CFR 0.152.
 */
package org.mule.serialization.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.serialization.AbstractObjectSerializerContractTestCase;
import org.mule.serialization.internal.NodeWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NodeWrapperSerializationTestCase
extends AbstractObjectSerializerContractTestCase {
    private XPath xpath;

    @Override
    protected void doSetUp() throws Exception {
        this.serializer = muleContext.getObjectSerializer();
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    @Test
    public void testWrappedTextNode() throws Exception {
        Node node = this.getNodeByXpath("<root>text</root>", "//root/text()");
        byte[] bytes = this.serializer.serialize((Object)new NodeWrapper(node));
        Object deserialized = this.serializer.deserialize(bytes);
        MatcherAssert.assertThat((Object)((Node)deserialized).getNodeName(), (Matcher)Matchers.containsString((String)"text"));
    }

    @Test
    public void testWrappedCdataNode() throws Exception {
        Node node = this.getNodeByXpath("<root><someelemwithcdata><![CDATA[Irene, myself & I]]></someelemwithcdata></root>", "//root/someelemwithcdata/text()");
        byte[] bytes = this.serializer.serialize((Object)new NodeWrapper(node));
        Object deserialized = this.serializer.deserialize(bytes);
        MatcherAssert.assertThat((Object)((Node)deserialized).getNodeName(), (Matcher)Matchers.containsString((String)"cdata"));
        MatcherAssert.assertThat((Object)((Node)deserialized).getTextContent(), (Matcher)Matchers.containsString((String)"Irene, myself & I"));
    }

    @Test
    public void testWrappedElementNode() throws Exception {
        Node node = this.getNodeByXpath("<root><elem><subelem>Hi</subelem></elem></root>", "//root/elem");
        byte[] bytes = this.serializer.serialize((Object)new NodeWrapper(node));
        NodeWrapper deserialized = (NodeWrapper)this.serializer.deserialize(bytes);
        Node found = this.findNodeByXPathExpression(deserialized, "//elem/subelem/text()");
        MatcherAssert.assertThat((Object)found.getNodeName(), (Matcher)Matchers.containsString((String)"text"));
        MatcherAssert.assertThat((Object)found.getTextContent(), (Matcher)Matchers.containsString((String)"Hi"));
    }

    @Test
    public void testWrappedAttributeNode() throws Exception {
        Node node = this.getNodeByXpath("<root><elem someatr=\"Howdy\"></elem></root>", "//root/elem/@someatr");
        byte[] bytes = this.serializer.serialize((Object)new NodeWrapper(node));
        NodeWrapper deserialized = (NodeWrapper)this.serializer.deserialize(bytes);
        MatcherAssert.assertThat((Object)deserialized.getNodeName(), (Matcher)Matchers.containsString((String)"someatr"));
        MatcherAssert.assertThat((Object)deserialized.getTextContent(), (Matcher)Matchers.containsString((String)"Howdy"));
    }

    @Test
    public void testWrappedCommentBeforeTextNode() throws Exception {
        Node node = this.getNodeByXpath("<root><elem><!-- this is a comment --> HI!</elem></root>", "//root/elem/comment()");
        byte[] bytes = this.serializer.serialize((Object)new NodeWrapper(node));
        NodeWrapper deserialized = (NodeWrapper)this.serializer.deserialize(bytes);
        MatcherAssert.assertThat((Object)deserialized.getNodeName(), (Matcher)Matchers.containsString((String)"comment"));
        MatcherAssert.assertThat((Object)deserialized.getTextContent(), (Matcher)Matchers.containsString((String)"this is a comment"));
    }

    @Test
    public void testWrappedCommentAfterTextNode() throws Exception {
        Node node = this.getNodeByXpath("<root><elem>HI! <!-- this is a comment --></elem></root>", "//root/elem/comment()");
        byte[] bytes = this.serializer.serialize((Object)new NodeWrapper(node));
        NodeWrapper deserialized = (NodeWrapper)this.serializer.deserialize(bytes);
        MatcherAssert.assertThat((Object)deserialized.getNodeName(), (Matcher)Matchers.containsString((String)"comment"));
        MatcherAssert.assertThat((Object)deserialized.getTextContent(), (Matcher)Matchers.containsString((String)"this is a comment"));
    }

    @Test
    public void testWrappedCommentBeforeElementNode() throws Exception {
        Node node = this.getNodeByXpath("<root><elem><!-- this is a comment --><sub>Bye</sub></elem></root>", "//root/elem/comment()");
        byte[] bytes = this.serializer.serialize((Object)new NodeWrapper(node));
        NodeWrapper deserialized = (NodeWrapper)this.serializer.deserialize(bytes);
        MatcherAssert.assertThat((Object)deserialized.getNodeName(), (Matcher)Matchers.containsString((String)"comment"));
        MatcherAssert.assertThat((Object)deserialized.getTextContent(), (Matcher)Matchers.containsString((String)"this is a comment"));
    }

    @Test
    public void testWrappedCommentAfterElementNode() throws Exception {
        Node node = this.getNodeByXpath("<root><elem><sub>Bye</sub><!-- this is a comment --></elem></root>", "//root/elem/comment()");
        byte[] bytes = this.serializer.serialize((Object)new NodeWrapper(node));
        NodeWrapper deserialized = (NodeWrapper)this.serializer.deserialize(bytes);
        MatcherAssert.assertThat((Object)deserialized.getNodeName(), (Matcher)Matchers.containsString((String)"comment"));
        MatcherAssert.assertThat((Object)deserialized.getTextContent(), (Matcher)Matchers.containsString((String)"this is a comment"));
    }

    @Test
    public void testWrappedProcessingInstructionNode() throws Exception {
        Node node = this.getNodeByXpath("<?xml-stylesheet type=\"text/xsl\" href=\"style.xsl\"?><root><elem><sub>Bye</sub><!-- this is a comment --></elem></root>", "//processing-instruction('xml-stylesheet')");
        byte[] bytes = this.serializer.serialize((Object)new NodeWrapper(node));
        NodeWrapper deserialized = (NodeWrapper)this.serializer.deserialize(bytes);
        MatcherAssert.assertThat((Object)deserialized.getNodeName(), (Matcher)Matchers.containsString((String)"xml-stylesheet"));
        MatcherAssert.assertThat((Object)deserialized.getTextContent(), (Matcher)Matchers.containsString((String)"type=\"text/xsl\" href=\"style.xsl\""));
    }

    private Node findNodeByXPathExpression(NodeWrapper nodeWrapper, String expression) throws XPathExpressionException {
        nodeWrapper.normalize();
        XPathExpression expr = this.xpath.compile(expression);
        return (Node)expr.evaluate(nodeWrapper.getNode(), XPathConstants.NODE);
    }

    private Node getNodeByXpath(String xmlString, String expression) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(new ByteArrayInputStream(xmlString.getBytes()));
        XPathExpression expr = this.xpath.compile(expression);
        return (Node)expr.evaluate(document, XPathConstants.NODE);
    }
}

