/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.session.SerializeAndEncodeSessionHandler;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@Ignore(value="This test has to be run alone, because the system property it sets invalidates the run of SerializeAndEncodeSessionHandlerTestCase afterwards")
public class SessionPropertiesTestCase
extends AbstractMuleContextTestCase {
    @ClassRule
    public static SystemProperty sessionSignKey = new SystemProperty("mule.session.serialization.native.enable", "true");
    private DefaultMuleMessage message;

    @Before
    public void setup() {
        this.message = new DefaultMuleMessage((Object)"data", muleContext);
        this.message.setInboundProperty("MULE_ENDPOINT", (Object)"http:whatever");
    }

    @Test
    public void setSessionPropertyNoEvent() throws Exception {
        try {
            this.message.setProperty("key", (Object)"value", PropertyScope.SESSION);
            Assert.fail((String)"IllegalStateException excepted");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            Assert.fail((String)"IllegalStateException excepted");
        }
        Assert.assertNull((Object)this.message.getProperty("key", PropertyScope.SESSION));
    }

    @Test
    public void setSessionPropertyOnMessageGetFromSession() throws Exception {
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.message, MessageExchangePattern.ONE_WAY, (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        this.message.setProperty("key", (Object)"value", PropertyScope.SESSION);
        this.message.setProperty("key2", nonSerializable, PropertyScope.SESSION);
        this.message.setProperty("key3", (Object)"ERROR", PropertyScope.INVOCATION);
        this.message.setProperty("key4", (Object)"ERROR", PropertyScope.INBOUND);
        this.message.setProperty("key5", (Object)"ERROR", PropertyScope.OUTBOUND);
        Assert.assertEquals((long)2L, (long)event.getSession().getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"value", (Object)event.getSession().getProperty("key"));
        Assert.assertEquals((Object)nonSerializable, (Object)event.getSession().getProperty("key2"));
    }

    @Test
    public void setSessionPropertyOnSessionGetFromMessage() throws Exception {
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.message, MessageExchangePattern.ONE_WAY, (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        event.getSession().setProperty("key", (Serializable)((Object)"value"));
        this.message.setProperty("key2", nonSerializable, PropertyScope.SESSION);
        Assert.assertEquals((long)2L, (long)this.message.getPropertyNames(PropertyScope.SESSION).size());
        Assert.assertEquals((Object)"value", (Object)this.message.getProperty("key", PropertyScope.SESSION));
        Assert.assertEquals((Object)nonSerializable, (Object)this.message.getProperty("key2", PropertyScope.SESSION));
        Assert.assertNull((Object)this.message.getProperty("key", PropertyScope.INVOCATION));
        Assert.assertNull((Object)this.message.getProperty("key", PropertyScope.INBOUND));
        Assert.assertNull((Object)this.message.getProperty("key", PropertyScope.OUTBOUND));
    }

    @Test
    public void asyncInterceptingProcessorSessionPropertyPropagation() throws Exception {
        AsyncInterceptingMessageProcessor async = new AsyncInterceptingMessageProcessor(muleContext.getDefaultThreadingProfile(), "async", 0);
        SensingNullMessageProcessor asyncListener = new SensingNullMessageProcessor();
        async.setListener((MessageProcessor)asyncListener);
        async.start();
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.message, MessageExchangePattern.ONE_WAY, (FlowConstruct)SessionPropertiesTestCase.getTestService());
        event.getSession().setProperty("key", (Serializable)((Object)"value"));
        async.process((MuleEvent)event);
        asyncListener.latch.await(5000L, TimeUnit.MILLISECONDS);
        MuleEvent asyncEvent = asyncListener.event;
        Assert.assertNotSame((Object)asyncEvent, (Object)event);
        Assert.assertNotSame((Object)asyncEvent, (Object)event);
        Assert.assertNotSame((Object)asyncEvent.getSession(), (Object)event.getSession());
        Assert.assertEquals((long)1L, (long)asyncEvent.getSession().getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"value", (Object)asyncEvent.getSession().getProperty("key"));
        asyncEvent.getSession().setProperty("newKey", (Serializable)((Object)"newValue"));
        Assert.assertEquals((long)2L, (long)asyncEvent.getSession().getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"newValue", (Object)asyncEvent.getSession().getProperty("newKey"));
        Assert.assertEquals((long)1L, (long)event.getSession().getPropertyNamesAsSet().size());
        Assert.assertNull((Object)event.getSession().getProperty("newKey"));
        async.stop();
    }

    @Test
    public void serializationSessionPropertyPropagation() throws Exception {
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.message, MessageExchangePattern.ONE_WAY, (FlowConstruct)SessionPropertiesTestCase.getTestService());
        event.getSession().setProperty("key", (Serializable)((Object)"value"));
        ObjectSerializer serializer = muleContext.getObjectSerializer();
        MuleEvent deserializedEvent = (MuleEvent)serializer.deserialize(serializer.serialize((Object)event));
        Assert.assertNotSame((Object)deserializedEvent, (Object)event);
        Assert.assertNotSame((Object)deserializedEvent, (Object)event);
        Assert.assertNotSame((Object)deserializedEvent.getSession(), (Object)event.getSession());
        Assert.assertFalse((boolean)deserializedEvent.getSession().equals(event.getSession()));
        Assert.assertEquals((long)1L, (long)deserializedEvent.getSession().getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"value", (Object)deserializedEvent.getSession().getProperty("key"));
        deserializedEvent.getSession().setProperty("newKey", (Serializable)((Object)"newValue"));
        Assert.assertEquals((long)2L, (long)deserializedEvent.getSession().getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"newValue", (Object)deserializedEvent.getSession().getProperty("newKey"));
        Assert.assertEquals((long)1L, (long)event.getSession().getPropertyNamesAsSet().size());
        Assert.assertNull((Object)event.getSession().getProperty("newKey"));
    }

    @Test
    public void defaultSessionHandlerSessionPropertyPropagation() throws Exception {
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.message, MessageExchangePattern.ONE_WAY, (FlowConstruct)SessionPropertiesTestCase.getTestService());
        event.getSession().setProperty("key", (Serializable)((Object)"value"));
        new SerializeAndEncodeSessionHandler().storeSessionInfoToMessage(event.getSession(), (MuleMessage)this.message);
        this.message.setProperty("MULE_SESSION", this.message.getProperty("MULE_SESSION", PropertyScope.OUTBOUND), PropertyScope.INBOUND);
        MuleSession newSession = new SerializeAndEncodeSessionHandler().retrieveSessionInfoFromMessage((MuleMessage)this.message);
        Assert.assertNotSame((Object)newSession, (Object)event.getSession());
        Assert.assertFalse((boolean)newSession.equals(event.getSession()));
        Assert.assertEquals((long)1L, (long)newSession.getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"value", (Object)newSession.getProperty("key"));
        newSession.setProperty("newKey", (Serializable)((Object)"newValue"));
        Assert.assertEquals((long)2L, (long)newSession.getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"newValue", (Object)newSession.getProperty("newKey"));
        Assert.assertEquals((long)1L, (long)event.getSession().getPropertyNamesAsSet().size());
        Assert.assertNull((Object)event.getSession().getProperty("newKey"));
    }

    @Test
    public void serializationNonSerializableSessionPropertyPropagation() throws Exception {
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.message, MessageExchangePattern.ONE_WAY, (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        event.getSession().setProperty("key", nonSerializable);
        this.message.setProperty("key2", (Object)"value2", PropertyScope.SESSION);
        ObjectSerializer serializer = muleContext.getObjectSerializer();
        MuleEvent deserialized = (MuleEvent)serializer.deserialize(serializer.serialize((Object)event));
        Assert.assertEquals((Object)nonSerializable, (Object)event.getSession().getProperty("key"));
        Assert.assertEquals((Object)"value2", (Object)event.getSession().getProperty("key2"));
        Assert.assertNotSame((Object)deserialized, (Object)event);
        Assert.assertNull((Object)deserialized.getSession().getProperty("key"));
        Assert.assertEquals((Object)"value2", (Object)deserialized.getSession().getProperty("key2"));
    }

    @Test
    public void defaultSessionHandlerNonSerializableSessionPropertyPropagation() throws Exception {
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.message, MessageExchangePattern.ONE_WAY, (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        this.message.setProperty("key", nonSerializable, PropertyScope.SESSION);
        this.message.setProperty("key2", (Object)"value2", PropertyScope.SESSION);
        new SerializeAndEncodeSessionHandler().storeSessionInfoToMessage(event.getSession(), (MuleMessage)this.message);
        this.message.setProperty("MULE_SESSION", this.message.getProperty("MULE_SESSION", PropertyScope.OUTBOUND), PropertyScope.INBOUND);
        MuleSession newSession = new SerializeAndEncodeSessionHandler().retrieveSessionInfoFromMessage((MuleMessage)this.message);
        Assert.assertNotSame((Object)newSession, (Object)event.getSession());
        Assert.assertFalse((boolean)newSession.equals(event.getSession()));
        Assert.assertEquals((Object)nonSerializable, (Object)event.getSession().getProperty("key"));
        Assert.assertEquals((Object)"value2", (Object)event.getSession().getProperty("key2"));
        Assert.assertEquals((long)1L, (long)newSession.getPropertyNamesAsSet().size());
        Assert.assertNull((Object)newSession.getProperty("key"));
        Assert.assertEquals((Object)"value2", (Object)newSession.getProperty("key2"));
    }

    @Test
    public void processFlowSessionPropertyPropagation() throws Exception {
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.message, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)SessionPropertiesTestCase.getTestService());
        SensingNullMessageProcessor flowListener = new SensingNullMessageProcessor();
        Flow flow = new Flow("flow", muleContext);
        flow.setMessageProcessors(Collections.singletonList(flowListener));
        flow.initialise();
        flow.start();
        Object nonSerializable = new Object();
        event.getSession().setProperty("key", (Serializable)((Object)"value"));
        event.getSession().setProperty("key2", nonSerializable);
        flow.process((MuleEvent)event);
        flowListener.latch.await(5000L, TimeUnit.MILLISECONDS);
        MuleEvent processedEvent = flowListener.event;
        Assert.assertNotSame((Object)processedEvent, (Object)event);
        Assert.assertEquals((Object)processedEvent, (Object)event);
        Assert.assertSame((Object)processedEvent.getSession(), (Object)event.getSession());
        Assert.assertEquals((long)2L, (long)processedEvent.getSession().getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"value", (Object)processedEvent.getSession().getProperty("key"));
        Assert.assertEquals((Object)nonSerializable, (Object)processedEvent.getSession().getProperty("key2"));
        processedEvent.getSession().setProperty("newKey", (Serializable)((Object)"newValue"));
        Assert.assertEquals((long)3L, (long)processedEvent.getSession().getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"newValue", (Object)processedEvent.getSession().getProperty("newKey"));
        Assert.assertEquals((long)3L, (long)event.getSession().getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"newValue", (Object)event.getSession().getProperty("newKey"));
        flow.stop();
        flow.dispose();
    }
}

