/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.graph.TransformationEdge;
import org.mule.transformer.graph.TransformationGraph;

@SmallTest
public class TransformationGraphTestCase
extends AbstractMuleTestCase {
    protected static final DataType XML_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"XML_DATA_TYPE");
    protected static final DataType JSON_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"JSON_DATA_TYPE");
    protected static final DataType INPUT_STREAM_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"INPUT_STREAM_DATA_TYPE");
    protected static final DataType STRING_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"STRING_DATA_TYPE");

    @BeforeClass
    public static void setupDataTypes() {
        ((DataType)Mockito.doReturn((Object)true).when((Object)XML_DATA_TYPE)).isCompatibleWith(XML_DATA_TYPE);
        ((DataType)Mockito.doReturn(XML_CLASS.class).when((Object)XML_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)JSON_DATA_TYPE)).isCompatibleWith(JSON_DATA_TYPE);
        ((DataType)Mockito.doReturn(JSON_CLASS.class).when((Object)JSON_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)INPUT_STREAM_DATA_TYPE)).isCompatibleWith(INPUT_STREAM_DATA_TYPE);
        ((DataType)Mockito.doReturn(INPUT_STREAM_CLASS.class).when((Object)INPUT_STREAM_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)STRING_DATA_TYPE)).isCompatibleWith(STRING_DATA_TYPE);
        ((DataType)Mockito.doReturn(STRING_CLASS.class).when((Object)STRING_DATA_TYPE)).getType();
    }

    @Test
    public void processesConverterAdded() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsVertex((Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void ignoresConverterAddedTwice() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.addConverter(xmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsVertex((Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void processesConverterAddedWithMultipleSourceTypes() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE, INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)graph.containsVertex((Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)INPUT_STREAM_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)graph.containsEdge((Object)INPUT_STREAM_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)INPUT_STREAM_DATA_TYPE), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void processesConverterRemoved() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.removeConverter(xmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void ignoresRemovingConverterThatWasNeverAdded() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        Converter betterXmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(2)).build();
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.removeConverter(betterXmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsVertex((Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void processesConverterRemovedWithMultipleSourceTypes() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE, INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.removeConverter(xmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void multipleConvertersFromSameSourceToResultTypes() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)xmlToJson.getName()).thenReturn((Object)"xmlToJson");
        Converter betterXmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)betterXmlToJson.getName()).thenReturn((Object)"betterXmlToJson");
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.addConverter(betterXmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsVertex((Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)false));
        this.assertContainsTransformer(graph.edgesOf((Object)JSON_DATA_TYPE), (Transformer)xmlToJson);
        this.assertContainsTransformer(graph.edgesOf((Object)JSON_DATA_TYPE), (Transformer)betterXmlToJson);
    }

    @Test
    public void removesFirstDuplicateConverterAdded() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)xmlToJson.getName()).thenReturn((Object)"xmlToJson");
        Converter betterXmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)betterXmlToJson.getName()).thenReturn((Object)"betterXmlToJson");
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.addConverter(betterXmlToJson);
        graph.removeConverter(xmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Set transformationEdges = graph.edgesOf((Object)JSON_DATA_TYPE);
        Assert.assertThat((Object)transformationEdges, (Matcher)Matchers.hasSize((int)1));
        this.assertContainsTransformer(transformationEdges, (Transformer)betterXmlToJson);
    }

    @Test
    public void removesSecondDuplicateConverterAdded() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter betterXmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.addConverter(betterXmlToJson);
        graph.removeConverter(betterXmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Set transformationEdges = graph.edgesOf((Object)JSON_DATA_TYPE);
        Assert.assertThat((Object)transformationEdges, (Matcher)Matchers.hasSize((int)1));
        this.assertContainsTransformer(transformationEdges, (Transformer)xmlToJson);
    }

    @Test
    public void multipleConvertersFromDifferentSourceToSameResultTypes() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)xmlToJson.getName()).thenReturn((Object)"xmlToJson");
        Converter objectToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)objectToJson.getName()).thenReturn((Object)"objectToJson");
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.addConverter(objectToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)graph.containsVertex((Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)INPUT_STREAM_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)graph.containsEdge((Object)INPUT_STREAM_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)INPUT_STREAM_DATA_TYPE), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void removeFirstAddedConverterWithDifferentSourceToSameResultTypes() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)xmlToJson.getName()).thenReturn((Object)"xmlToJson");
        Converter objectToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)objectToJson.getName()).thenReturn((Object)"objectToJson");
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.addConverter(objectToJson);
        graph.removeConverter(xmlToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)INPUT_STREAM_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)graph.containsEdge((Object)INPUT_STREAM_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)INPUT_STREAM_DATA_TYPE), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void reregisterDoesNotLeak() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)xmlToJson.getName()).thenReturn((Object)"xmlToJson");
        Converter xmlToJsonCopy = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)xmlToJsonCopy.getName()).thenReturn((Object)"xmlToJson");
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.addConverter(xmlToJsonCopy);
        Assert.assertThat(graph.registeredConverters.keySet(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void removeSecondAddedConverterWithDifferentSourceToSameResultTypes() {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)xmlToJson.getName()).thenReturn((Object)"xmlToJson");
        Converter objectToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)objectToJson.getName()).thenReturn((Object)"objectToJson");
        TransformationGraph graph = new TransformationGraph();
        graph.addConverter(xmlToJson);
        graph.addConverter(objectToJson);
        graph.removeConverter(objectToJson);
        Assert.assertThat((Object)graph.vertexSet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)graph.containsVertex((Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsVertex((Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.edgeSet(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)graph.containsEdge((Object)INPUT_STREAM_DATA_TYPE, (Object)JSON_DATA_TYPE), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)graph.containsEdge((Object)JSON_DATA_TYPE, (Object)INPUT_STREAM_DATA_TYPE), (Matcher)Matchers.is((Object)false));
    }

    private void assertContainsTransformer(Set<TransformationEdge> transformationEdges, Transformer transformer) {
        for (TransformationEdge edge : transformationEdges) {
            if (edge.getConverter() != transformer) continue;
            return;
        }
        junit.framework.Assert.fail((String)String.format("Transformation edges %s do not contain expected transformer %s", transformationEdges, transformer));
    }

    protected static class STRING_CLASS {
        protected STRING_CLASS() {
        }
    }

    protected static class INPUT_STREAM_CLASS {
        protected INPUT_STREAM_CLASS() {
        }
    }

    protected static class JSON_CLASS {
        protected JSON_CLASS() {
        }
    }

    protected static class XML_CLASS {
        protected XML_CLASS() {
        }
    }
}

