/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.simple.GetBeanProperty;

@SmallTest
public class GetBeanPropertyTestCase
extends AbstractMuleTestCase {
    private CustomBean bean = new CustomBean();
    private GetBeanProperty transformer = new GetBeanProperty();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void classPropertySuppressed() throws Exception {
        this.thrown.expect(TransformerException.class);
        this.thrown.expectCause(CoreMatchers.isA(NoSuchMethodException.class));
        this.thrown.expectMessage(CoreMatchers.startsWith((String)"Unknown property 'class'"));
        this.transformer.setPropertyName("class");
        this.transformer.transform((Object)this.bean);
    }

    @Test
    public void commonPropertyAccessed() throws Exception {
        this.transformer.setPropertyName("name");
        MatcherAssert.assertThat((Object)this.transformer.transform((Object)this.bean).toString(), (Matcher)CoreMatchers.is((Object)"dangerousBean"));
    }

    public class CustomBean {
        int id = 1337;
        String name = "dangerousBean";

        private CustomBean() {
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

