/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.PollingReceiverWorker;

@SmallTest
public class PollingReceiverWorkerTestCase
extends AbstractMuleTestCase {
    @Test
    public void skipsPollingWhenMuleContextIsStopping() throws Exception {
        AbstractPollingMessageReceiver messageReceiver = this.createPollingMessageReceiver(true);
        PollingReceiverWorker pollingReceiverWorker = new PollingReceiverWorker(messageReceiver);
        pollingReceiverWorker.run();
        ((AbstractPollingMessageReceiver)Mockito.verify((Object)messageReceiver, (VerificationMode)Mockito.never())).performPoll();
    }

    @Test
    public void executesPollingWhenMuleContextIsNotStopping() throws Exception {
        AbstractPollingMessageReceiver messageReceiver = this.createPollingMessageReceiver(false);
        PollingReceiverWorker pollingReceiverWorker = new PollingReceiverWorker(messageReceiver);
        pollingReceiverWorker.run();
        ((AbstractPollingMessageReceiver)Mockito.verify((Object)messageReceiver)).performPoll();
    }

    @Test
    public void requestContextIsCleanAfterPolling() throws Exception {
        AbstractPollingMessageReceiver messageReceiver = this.mockRequestContextUseInPollingReceiver(this.createPollingMessageReceiver(false));
        PollingReceiverWorker pollingReceiverWorker = new PollingReceiverWorker(messageReceiver);
        pollingReceiverWorker.run();
        Assert.assertThat((Object)RequestContext.getEvent(), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    private AbstractPollingMessageReceiver createPollingMessageReceiver(boolean isStopping) {
        AbstractPollingMessageReceiver messageReceiver = (AbstractPollingMessageReceiver)Mockito.mock(AbstractPollingMessageReceiver.class);
        Mockito.when((Object)messageReceiver.isStarted()).thenReturn((Object)true);
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)flowConstruct.getMuleContext()).thenReturn((Object)muleContext);
        Mockito.when((Object)muleContext.isStopping()).thenReturn((Object)isStopping);
        Mockito.when((Object)messageReceiver.getFlowConstruct()).thenReturn((Object)flowConstruct);
        return messageReceiver;
    }

    private AbstractPollingMessageReceiver mockRequestContextUseInPollingReceiver(AbstractPollingMessageReceiver pollingMessageReceiver) throws Exception {
        ((AbstractPollingMessageReceiver)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                OptimizedRequestContext.criticalSetEvent((MuleEvent)((MuleEvent)Mockito.mock(MuleEvent.class)));
                return null;
            }
        }).when((Object)pollingMessageReceiver)).performPoll();
        return pollingMessageReceiver;
    }
}

