/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.util.HashMap;
import javax.activation.MimetypesFileTypeMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class FileExtensionContentTypeResolutionTestCase
extends AbstractMuleTestCase {
    private static final MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    @Test
    public void resolvesFileMimeType() throws Exception {
        HashMap<String, String> mimeTypes = new HashMap<String, String>();
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("json", "text/json");
        mimeTypes.put("xml", "text/xml");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("csv", "text/csv");
        for (String extension : mimeTypes.keySet()) {
            this.doFileMimeTypeTest(extension, (String)mimeTypes.get(extension));
        }
    }

    @Test
    public void resolvesDefaultMimeType() throws Exception {
        this.doFileMimeTypeTest("xxxxxx", DEFAULT_CONTENT_TYPE);
    }

    private void doFileMimeTypeTest(String fileExtension, String expectedMimeType) throws IOException {
        String filename = "test." + fileExtension;
        String mimeType = mimetypesFileTypeMap.getContentType(filename);
        MatcherAssert.assertThat((Object)mimeType, (Matcher)CoreMatchers.equalTo((Object)expectedMimeType));
    }
}

