/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

@SmallTest
public class StringMessageUtilsTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void toStringOnStringShouldReturnTheString() {
        String input = "Oscar";
        String result = StringMessageUtils.toString((Object)input);
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void toStringOnClassShouldReturnClassName() {
        Class<?> test = this.getClass();
        String result = StringMessageUtils.toString(test);
        Assert.assertEquals((Object)this.getClass().getName(), (Object)result);
    }

    @Test
    public void toStringOnObjectShouldReturnObjectsToStringRepresentation() {
        TestObject test = new TestObject("Ernie");
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)test.toString(), (Object)result);
        test = new AnotherTestObject("Bert");
        result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"Bert", (Object)result);
    }

    @Test
    public void toStringOnStringArrayShouldReturnStringRepresentation() {
        String[] test = new String[]{"foo", "bar"};
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"{foo,bar}", (Object)result);
    }

    @Test
    public void toStringOnByteArrayShouldReturnStringRepresentation() {
        byte[] test = new byte[]{1, 2};
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"{1,2}", (Object)result);
    }

    @Test
    public void toStringOnByteArrayLargerThanMaximumOutputLengthShouldReturnAbbreviatedStringRepresentation() {
        byte[] test = new byte[150];
        for (int i = 0; i < test.length; ++i) {
            test[i] = (byte)i;
        }
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertTrue((boolean)result.endsWith("[..]}"));
        Assert.assertEquals((long)49L, (long)StringUtils.countMatches((String)result, (String)","));
    }

    @Test
    public void toStringOnLongArrayShouldReturnStringRepresentation() {
        long[] test = new long[]{5068875495743534L, 457635546759674L};
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"{5068875495743534,457635546759674}", (Object)result);
    }

    @Test
    public void toStringOnDoubleArrayShouldReturnStringRepresentation() {
        double[] test = new double[]{1.1, 2.02};
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"{1.1,2.02}", (Object)result);
    }

    @Test
    public void toStringOnListLargerThanMaximumOutputLengthShouldReturnAbbreviatedStringRepresentation() {
        ArrayList<Integer> list = new ArrayList<Integer>(100);
        for (int i = 0; i < 100; ++i) {
            list.add(new Integer(i));
        }
        String result = StringMessageUtils.toString(list);
        Assert.assertTrue((boolean)result.endsWith("[..]]"));
        Assert.assertEquals((long)49L, (long)StringUtils.countMatches((String)result, (String)","));
    }

    @Test
    public void testFormattedString() {
        String msg1 = "There is not substitution here";
        String result = StringMessageUtils.getFormattedMessage((String)msg1, null);
        Assert.assertEquals((Object)msg1, (Object)result);
        result = StringMessageUtils.getFormattedMessage((String)msg1, (Object[])new Object[0]);
        Assert.assertEquals((Object)msg1, (Object)result);
        String msg2 = "There should be a variable {0}, {1} and {2}";
        result = StringMessageUtils.getFormattedMessage((String)msg2, (Object[])new Object[]{"here", "there", "everywhere"});
        Assert.assertEquals((Object)"There should be a variable here, there and everywhere", (Object)result);
    }

    @Test
    public void testBoilerPlateSingleLine() {
        String plate = StringMessageUtils.getBoilerPlate((String)"Single message.", (char)'*', (int)12);
        Assert.assertEquals((Object)(SystemUtils.LINE_SEPARATOR + "************" + SystemUtils.LINE_SEPARATOR + "* Single   *" + SystemUtils.LINE_SEPARATOR + "* message. *" + SystemUtils.LINE_SEPARATOR + "************"), (Object)plate);
    }

    @Test
    public void testBoilerPlate() {
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("This");
        msgs.add("is a");
        msgs.add("Boiler Plate");
        String plate = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)12);
        Assert.assertEquals((Object)(SystemUtils.LINE_SEPARATOR + "************" + SystemUtils.LINE_SEPARATOR + "* This     *" + SystemUtils.LINE_SEPARATOR + "* is a     *" + SystemUtils.LINE_SEPARATOR + "* Boiler   *" + SystemUtils.LINE_SEPARATOR + "* Plate    *" + SystemUtils.LINE_SEPARATOR + "************"), (Object)plate);
    }

    @Test
    public void testBoilerPlate2() {
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("This");
        msgs.add("is a");
        msgs.add("Boiler Plate Message that should get wrapped to the next line if it is working properly");
        String plate = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)12);
        Assert.assertEquals((Object)(SystemUtils.LINE_SEPARATOR + "************" + SystemUtils.LINE_SEPARATOR + "* This     *" + SystemUtils.LINE_SEPARATOR + "* is a     *" + SystemUtils.LINE_SEPARATOR + "* Boiler   *" + SystemUtils.LINE_SEPARATOR + "* Plate    *" + SystemUtils.LINE_SEPARATOR + "* Message  *" + SystemUtils.LINE_SEPARATOR + "* that     *" + SystemUtils.LINE_SEPARATOR + "* should   *" + SystemUtils.LINE_SEPARATOR + "* get      *" + SystemUtils.LINE_SEPARATOR + "* wrapped  *" + SystemUtils.LINE_SEPARATOR + "* to the   *" + SystemUtils.LINE_SEPARATOR + "* next     *" + SystemUtils.LINE_SEPARATOR + "* line if  *" + SystemUtils.LINE_SEPARATOR + "* it is    *" + SystemUtils.LINE_SEPARATOR + "* working  *" + SystemUtils.LINE_SEPARATOR + "* properly *" + SystemUtils.LINE_SEPARATOR + "************"), (Object)plate);
    }

    @Test
    public void testTruncate() {
        String msg = "this is a test message for truncating";
        String result = StringMessageUtils.truncate((String)msg, (int)100, (boolean)true);
        Assert.assertEquals((Object)msg, (Object)result);
        result = StringMessageUtils.truncate((String)msg, (int)10, (boolean)false);
        Assert.assertEquals((Object)"this is a ...", (Object)result);
        result = StringMessageUtils.truncate((String)msg, (int)10, (boolean)true);
        Assert.assertEquals((Object)"this is a ...[10 of 37]", (Object)result);
    }

    @Test
    public void headersToStringWithoutKeyWords() {
        MuleMessage message = this.getTestMuleMessage();
        message.setProperty("password", (Object)"123", PropertyScope.INBOUND);
        message.setProperty("secret", (Object)"shh", PropertyScope.INBOUND);
        message.setProperty("authorization", (Object)"granted", PropertyScope.INBOUND);
        String headers = StringMessageUtils.headersToString((MuleMessage)message);
        MatcherAssert.assertThat((Object)headers, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)"123")));
        MatcherAssert.assertThat((Object)headers, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)"shh")));
        MatcherAssert.assertThat((Object)headers, (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)"granted")));
    }

    private class AnotherTestObject
    extends TestObject {
        public AnotherTestObject(String name) {
            super(name);
        }

        public String toString() {
            return this.getName();
        }
    }

    private class TestObject {
        private String myName;

        public TestObject(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }
    }
}

