/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.endpoint.ResourceNameEndpointURIBuilder;

public class JmsEndpointURIBuilder
extends ResourceNameEndpointURIBuilder {
    protected void setEndpoint(URI uri, Properties props) throws MalformedEndpointException {
        super.setEndpoint(uri, props);
        String oldUri = uri.toString();
        String newUri = null;
        if (uri.getScheme().equals("topic")) {
            props.setProperty("resourceInfo", "topic");
            newUri = uri.toString().replace("topic://", "jms://");
        } else if (uri.getScheme().equals("queue")) {
            newUri = uri.toString().replace("queue://", "jms://");
        } else if (oldUri.startsWith("jms://queue://")) {
            newUri = uri.toString().replace("jms://queue://", "jms://queue:");
        } else if (oldUri.startsWith("jms://temp-queue://")) {
            newUri = uri.toString().replace("jms://temp-queue://", "jms://temp-queue:");
        } else if (oldUri.startsWith("jms://topic://")) {
            props.setProperty("resourceInfo", "topic");
            newUri = uri.toString().replace("jms://topic://", "jms://topic:");
        }
        try {
            String resourceInfo;
            if (newUri != null) {
                this.rewriteURI(new URI(newUri));
            }
            if ((resourceInfo = props.getProperty("resourceInfo")) != null && !resourceInfo.equals("topic") && !resourceInfo.equals("queue")) {
                this.address = resourceInfo + ":" + this.address;
            }
        }
        catch (URISyntaxException e) {
            throw new MalformedEndpointException((Throwable)e);
        }
    }

    protected void processAuthority(String authority) {
        this.address = authority.equals(this.address + ":") ? authority : this.address + authority;
        this.processUserInfo();
    }
}

