/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.filter;

import java.lang.reflect.Array;
import java.util.regex.Pattern;
import org.mortbay.cometd.filter.JSONDataFilter;

public class RegexFilter
extends JSONDataFilter {
    String[] _templates;
    String[] _replaces;
    transient Pattern[] _patterns;

    public void init(Object init) {
        super.init(init);
        this._templates = new String[Array.getLength(init)];
        this._replaces = new String[this._templates.length];
        for (int i = 0; i < this._templates.length; ++i) {
            Object entry = Array.get(init, i);
            this._templates[i] = (String)Array.get(entry, 0);
            this._replaces[i] = (String)Array.get(entry, 1);
        }
        this.checkPatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPatterns() {
        RegexFilter regexFilter = this;
        synchronized (regexFilter) {
            if (this._patterns == null) {
                this._patterns = new Pattern[this._templates.length];
                for (int i = 0; i < this._patterns.length; ++i) {
                    this._patterns[i] = Pattern.compile(this._templates[i]);
                }
            }
        }
    }

    protected Object filterString(String string) {
        this.checkPatterns();
        for (int i = 0; i < this._patterns.length; ++i) {
            if (this._replaces[i] != null) {
                string = this._patterns[i].matcher(string).replaceAll(this._replaces[i]);
                continue;
            }
            if (!this._patterns[i].matcher(string).matches()) continue;
            throw new IllegalStateException("matched " + this._patterns[i] + " in " + string);
        }
        return string;
    }
}

