/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.net.URI;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.endpoint.AbstractEndpointURIBuilder;

public class ResourceNameEndpointURIBuilder
extends AbstractEndpointURIBuilder {
    private Pattern REGEX_SEPARATOR = Pattern.compile("([^:]*:(?!:))?([^:]*(?::*)?[^:]*)");
    protected static final Log logger = LogFactory.getLog(ResourceNameEndpointURIBuilder.class);
    public static final String RESOURCE_INFO_PROPERTY = "resourceInfo";

    @Override
    protected void setEndpoint(URI uri, Properties props) throws MalformedEndpointException {
        Matcher matcher;
        this.address = "";
        String host = uri.getHost();
        if (host != null && !"localhost".equals(host)) {
            this.address = host;
        }
        String path = uri.getPath();
        String authority = uri.getAuthority();
        if (path != null && path.length() != 0) {
            if (this.address.length() > 0) {
                this.address = this.address + "/";
            }
            this.address = this.address + path.substring(1);
        } else if (authority != null && !authority.equals(this.address)) {
            this.processAuthority(authority);
        }
        int y = this.address.indexOf("@");
        if (y > -1) {
            this.userInfo = this.address.substring(0, y);
        }
        ++y;
        String credentials = uri.getUserInfo();
        if (credentials != null && credentials.length() != 0) {
            this.userInfo = credentials;
        }
        if ((matcher = this.REGEX_SEPARATOR.matcher(this.address)).matches()) {
            String resourceInfo = matcher.group(1);
            this.setResourceInfoAsPropertyIfNeeded(props, resourceInfo);
            this.address = matcher.group(2);
        }
    }

    protected void processAuthority(String authority) {
        this.address = this.address + authority;
        this.processUserInfo();
    }

    protected void processUserInfo() {
        int atCharIndex = -1;
        if (this.address != null && this.address.length() != 0 && (atCharIndex = this.address.indexOf("@")) > -1) {
            this.userInfo = this.address.substring(0, atCharIndex);
            this.address = this.address.substring(atCharIndex + 1);
        }
    }

    private void setResourceInfoAsPropertyIfNeeded(Properties props, String resourceInfo) {
        if (resourceInfo != null) {
            resourceInfo = resourceInfo == null ? resourceInfo : resourceInfo.substring(0, resourceInfo.length() - 1);
            props.setProperty(RESOURCE_INFO_PROPERTY, resourceInfo);
        }
    }
}

