/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.NonBlockingSupported;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.MessageProcessorPathResolver;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAware;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.NonBlockingReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.AsyncMessageNotification;
import org.mule.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.AsyncWorkListener;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.work.AbstractMuleEventWork;

public class AsyncInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Startable,
Stoppable,
MessagingExceptionHandlerAware,
NonBlockingSupported {
    public static final String SYNCHRONOUS_NONBLOCKING_EVENT_ERROR_MESSAGE = "Unable to process a synchronous or non-blocking event asynchronously";
    protected WorkManagerSource workManagerSource;
    protected boolean doThreading = true;
    protected long threadTimeout;
    protected WorkManager workManager;
    private MessagingExceptionHandler messagingExceptionHandler;

    public AsyncInterceptingMessageProcessor(WorkManagerSource workManagerSource) {
        this.workManagerSource = workManagerSource;
    }

    public AsyncInterceptingMessageProcessor(ThreadingProfile threadingProfile, String name, int shutdownTimeout) {
        this.doThreading = threadingProfile.isDoThreading();
        this.threadTimeout = threadingProfile.getThreadWaitTimeout();
        if (threadingProfile.getMaxThreadsActive() == 1) {
            this.logger.warn((Object)"The threading profile was set to use only one active. This thread shall be used for the work manager polling. Async Processing strategy will not be able to schedule works!Please verify the threading profile configuration and update the maxThreads");
        }
        this.workManager = threadingProfile.createWorkManager(name, shutdownTimeout);
        this.workManagerSource = new WorkManagerSource(){

            @Override
            public WorkManager getWorkManager() throws MuleException {
                return AsyncInterceptingMessageProcessor.this.workManager;
            }
        };
    }

    @Override
    public void start() throws MuleException {
        if (this.workManager != null && !this.workManager.isStarted()) {
            this.workManager.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.workManager != null) {
            this.workManager.dispose();
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (this.isProcessAsync(event)) {
            this.processNextAsync(event);
            return VoidMuleEvent.getInstance();
        }
        MuleEvent response = this.processNext(event);
        return response;
    }

    protected MuleEvent processNextTimed(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking next MessageProcessor: '" + this.next.getClass().getName() + "' "));
        }
        MuleEvent response = event.getFlowConstruct() != null ? new ProcessingTimeInterceptor(this.next, event.getFlowConstruct()).process(event) : this.processNext(event);
        return response;
    }

    protected boolean isProcessAsync(MuleEvent event) throws MessagingException {
        if (!this.canProcessAsync(event)) {
            throw new MessagingException(CoreMessages.createStaticMessage(SYNCHRONOUS_NONBLOCKING_EVENT_ERROR_MESSAGE), event, (MessageProcessor)this);
        }
        return this.doThreading && this.canProcessAsync(event);
    }

    protected boolean canProcessAsync(MuleEvent event) throws MessagingException {
        return !event.isSynchronous() && !event.isTransacted() && !(event.getReplyToHandler() instanceof NonBlockingReplyToHandler);
    }

    protected void processNextAsync(MuleEvent event) throws MuleException {
        try {
            this.workManagerSource.getWorkManager().scheduleWork(new AsyncMessageProcessorWorker(event), Long.MAX_VALUE, null, new AsyncWorkListener(this.next));
            this.fireAsyncScheduledNotification(event);
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.errorSchedulingMessageProcessorForAsyncInvocation(this.next), event, e, this);
        }
    }

    protected void fireAsyncScheduledNotification(MuleEvent event) {
        if (event.getFlowConstruct() instanceof MessageProcessorPathResolver) {
            this.muleContext.getNotificationManager().fireNotification(new AsyncMessageNotification(event.getFlowConstruct(), event, this.next, 1901));
        }
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        if (this.messagingExceptionHandler == null) {
            this.messagingExceptionHandler = messagingExceptionHandler;
        }
    }

    protected void firePipelineNotification(MuleEvent event, MessagingException exception) {
        if (event.getFlowConstruct() instanceof MessageProcessorPathResolver) {
            this.muleContext.getNotificationManager().fireNotification(new AsyncMessageNotification(event.getFlowConstruct(), event, this.next, 1902, exception));
        }
    }

    class AsyncMessageProcessorWorker
    extends AbstractMuleEventWork {
        public AsyncMessageProcessorWorker(MuleEvent event) {
            super(event, true);
        }

        public AsyncMessageProcessorWorker(MuleEvent event, boolean copy) {
            super(event, copy);
        }

        @Override
        protected void doRun() {
            MessagingExceptionHandler exceptionHandler = AsyncInterceptingMessageProcessor.this.messagingExceptionHandler;
            TransactionalErrorHandlingExecutionTemplate executionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(AsyncInterceptingMessageProcessor.this.muleContext, new MuleTransactionConfig(), exceptionHandler);
            try {
                executionTemplate.execute(new ExecutionCallback<MuleEvent>(){

                    @Override
                    public MuleEvent process() throws Exception {
                        MessagingException exceptionThrown = null;
                        try {
                            AsyncInterceptingMessageProcessor.this.processNextTimed(AsyncMessageProcessorWorker.this.event);
                        }
                        catch (MessagingException e) {
                            exceptionThrown = e;
                            throw e;
                        }
                        catch (Exception e) {
                            exceptionThrown = new MessagingException(AsyncMessageProcessorWorker.this.event, e, AsyncInterceptingMessageProcessor.this.next);
                            throw exceptionThrown;
                        }
                        finally {
                            AsyncInterceptingMessageProcessor.this.firePipelineNotification(AsyncMessageProcessorWorker.this.event, exceptionThrown);
                        }
                        return VoidMuleEvent.getInstance();
                    }
                });
            }
            catch (MessagingException messagingException) {
            }
            catch (Exception e) {
                AsyncInterceptingMessageProcessor.this.muleContext.getExceptionListener().handleException(e);
            }
        }
    }
}

