/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.MessageExchangePattern;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.transport.NonBlockingReplyToHandler;
import org.mule.api.transport.ReplyToHandler;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.processor.BlockingProcessorExecutor;
import org.mule.processor.NonBlockingMessageProcessor;
import org.mule.util.OneTimeWarning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingProcessorExecutor
extends BlockingProcessorExecutor {
    private static final Logger logger = LoggerFactory.getLogger(NonBlockingProcessorExecutor.class);
    private final ReplyToHandler replyToHandler;
    private final MessageExchangePattern messageExchangePattern;
    final OneTimeWarning fallbackWarning = new OneTimeWarning(logger, "The message processor {} does not currently support non-blocking execution and processing will now fall back to blocking.  The 'non-blocking' processing strategy is not recommended if unsupported message processors are being used.  ");

    public NonBlockingProcessorExecutor(MuleEvent event, List<MessageProcessor> processors, MessageProcessorExecutionTemplate executionTemplate, boolean copyOnVoidEvent) {
        super(event, processors, executionTemplate, copyOnVoidEvent);
        this.replyToHandler = event.getReplyToHandler();
        this.messageExchangePattern = event.getExchangePattern();
    }

    @Override
    protected void preProcess(MessageProcessor processor) {
        if (this.event.isAllowNonBlocking()) {
            if (!this.processorSupportsNonBlocking(processor)) {
                this.fallbackWarning.warn(processor.getClass());
                this.event = new DefaultMuleEvent(this.event, this.event.getFlowConstruct(), null, null, true);
                OptimizedRequestContext.unsafeSetEvent(this.event);
            }
            if (processor instanceof NonBlockingMessageProcessor && (!this.messageExchangePattern.hasResponse() || this.replyToHandler != null)) {
                this.event = new DefaultMuleEvent(this.event, new NonBlockingProcessorExecutorReplyToHandler());
                OptimizedRequestContext.unsafeSetEvent(this.event);
            }
        }
    }

    private boolean processorSupportsNonBlocking(MessageProcessor processor) {
        if (processor instanceof NonBlockingSupported) {
            return true;
        }
        if (processor instanceof AsyncInterceptingMessageProcessor && !this.messageExchangePattern.hasResponse()) {
            return true;
        }
        return !(processor instanceof MessageProcessorContainer) && !(processor instanceof InterceptingMessageProcessor);
    }

    private void resume(MuleEvent event) throws MuleException {
        this.event = this.recreateEventWithOriginalReplyToHandler(event);
        MuleEvent result = this.execute();
        if (!(result instanceof NonBlockingVoidMuleEvent) && this.replyToHandler != null) {
            this.replyToHandler.processReplyTo(result, null, null);
        }
    }

    private MuleEvent recreateEventWithOriginalReplyToHandler(MuleEvent event) {
        if (event != null) {
            event = new DefaultMuleEvent(event, this.replyToHandler);
            OptimizedRequestContext.unsafeSetEvent(event);
        }
        return event;
    }

    class NonBlockingProcessorExecutorReplyToHandler
    implements NonBlockingReplyToHandler {
        NonBlockingProcessorExecutorReplyToHandler() {
        }

        @Override
        public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
            try {
                NonBlockingProcessorExecutor.this.resume(event);
            }
            catch (Throwable e) {
                if (e instanceof MessagingException) {
                    this.processExceptionReplyTo((MessagingException)e, replyTo);
                }
                this.processExceptionReplyTo(new MessagingException(event, e), replyTo);
            }
        }

        @Override
        public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
            if (NonBlockingProcessorExecutor.this.replyToHandler != null) {
                NonBlockingProcessorExecutor.this.replyToHandler.processExceptionReplyTo(exception, replyTo);
            } else {
                NonBlockingProcessorExecutor.this.event.getFlowConstruct().getExceptionListener().handleException(exception, exception.getEvent());
            }
        }
    }
}

