/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.notification.FlowTraceManager;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.processor.chain.DynamicMessageProcessorContainer;
import org.mule.processor.chain.InterceptingChainLifecycleWrapper;
import org.mule.processor.chain.SubFlowMessageProcessor;
import org.mule.util.NotificationUtils;

public class SubflowInterceptingChainLifecycleWrapper
extends InterceptingChainLifecycleWrapper
implements SubFlowMessageProcessor {
    private String subFlowName;

    public SubflowInterceptingChainLifecycleWrapper(MessageProcessorChain chain, List<MessageProcessor> processors, String name) {
        super(chain, processors, name);
        this.subFlowName = name;
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        MessageProcessorPathElement subprocessors = pathElement.addChild(this.name).addChild("subprocessors");
        ArrayList<MessageProcessor> filteredMessageProcessorList = new ArrayList<MessageProcessor>();
        ArrayList<DynamicMessageProcessorContainer> dynamicMessageProcessorContainers = new ArrayList<DynamicMessageProcessorContainer>();
        for (MessageProcessor messageProcessor : this.processors) {
            if (messageProcessor instanceof InterceptingMessageProcessor) {
                filteredMessageProcessorList.add(messageProcessor);
                break;
            }
            filteredMessageProcessorList.add(messageProcessor);
            if (!(messageProcessor instanceof DynamicMessageProcessorContainer)) continue;
            dynamicMessageProcessorContainers.add((DynamicMessageProcessorContainer)messageProcessor);
        }
        NotificationUtils.addMessageProcessorPathElements(filteredMessageProcessorList, subprocessors);
        for (DynamicMessageProcessorContainer dynamicMessageProcessorContainer : dynamicMessageProcessorContainers) {
            dynamicMessageProcessorContainer.buildInnerPaths();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        FlowTraceManager flowTraceManager = event.getMuleContext().getFlowTraceManager();
        flowTraceManager.onFlowStart(event, this.getSubFlowName());
        try {
            MuleEvent muleEvent = super.process(event);
            return muleEvent;
        }
        finally {
            flowTraceManager.onFlowComplete(event);
        }
    }

    @Override
    public String getSubFlowName() {
        return this.subFlowName;
    }
}

