/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.text.MessageFormat;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.store.ObjectStoreNotAvaliableException;
import org.mule.processor.AbstractFilteringMessageProcessor;
import org.mule.util.concurrent.ThreadNameHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentMessageFilter
extends AbstractFilteringMessageProcessor
implements FlowConstructAware,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdempotentMessageFilter.class);
    protected volatile ObjectStore<String> store;
    protected FlowConstruct flowConstruct;
    protected String storePrefix;
    protected String idExpression = MessageFormat.format("{0}message:id{1}", "#[", "]");
    protected String valueExpression = MessageFormat.format("{0}message:id{1}", "#[", "]");

    @Override
    public void initialise() throws InitialisationException {
        if (this.storePrefix == null) {
            this.storePrefix = String.format("%s.%s.%s", ThreadNameHelper.getPrefix(this.muleContext), this.flowConstruct == null ? "" : this.flowConstruct.getName(), this.getClass().getName());
        }
        if (this.store == null) {
            this.store = this.createMessageIdStore();
        }
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof Initialisable) {
            ((Initialisable)((Object)this.unacceptedMessageProcessor)).initialise();
        }
        LifecycleUtils.initialiseIfNeeded(this.store);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.store, LOGGER);
    }

    protected ObjectStore<String> createMessageIdStore() throws InitialisationException {
        ObjectStoreManager objectStoreManager = (ObjectStoreManager)this.muleContext.getRegistry().get("_muleObjectStoreManager");
        return objectStoreManager.getObjectStore(this.storePrefix, false, -1, 300000, 6000);
    }

    @Override
    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        return super.processNext(event);
    }

    protected String getValueForEvent(MuleEvent event) throws MessagingException {
        return event.getMuleContext().getExpressionManager().parse(this.valueExpression, event, true);
    }

    protected String getIdForEvent(MuleEvent event) throws MessagingException {
        return event.getMuleContext().getExpressionManager().parse(this.idExpression, event, true);
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public ObjectStore<String> getStore() {
        return this.store;
    }

    public void setStore(ObjectStore<String> store) {
        this.store = store;
    }

    @Override
    protected boolean accept(MuleEvent event) {
        if (event != null && this.acceptMessageForFlowConstruct(event) && this.isNewMessage(event)) {
            try {
                String id = this.getIdForEvent(event);
                String value = this.getValueForEvent(event);
                try {
                    this.store.store((Serializable)((Object)id), value);
                    return true;
                }
                catch (ObjectAlreadyExistsException ex) {
                    return false;
                }
                catch (ObjectStoreNotAvaliableException e) {
                    this.logger.error((Object)("ObjectStore not available: " + e.getMessage()));
                    return false;
                }
                catch (ObjectStoreException e) {
                    this.logger.warn((Object)("ObjectStore exception: " + e.getMessage()));
                    return false;
                }
            }
            catch (MessagingException e) {
                this.logger.warn((Object)("Could not retrieve Id or Value for event: " + e.getMessage()));
                return false;
            }
        }
        return false;
    }

    protected boolean acceptMessageForFlowConstruct(MuleEvent event) {
        if (this.flowConstruct.getName().equals(event.getFlowConstruct().getName())) {
            return true;
        }
        this.logger.error((Object)("This IdempotentMessageFilter was configured on the service: " + this.storePrefix + " but has received an event for service: " + this.flowConstruct.getName() + ". Please check your config to make sure each servicehas its own instance of IdempotentMessageFilter."));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isNewMessage(MuleEvent event) {
        try {
            String id = this.getIdForEvent(event);
            if (this.store == null) {
                IdempotentMessageFilter idempotentMessageFilter = this;
                synchronized (idempotentMessageFilter) {
                    this.initialise();
                }
            }
            return !this.store.contains((Serializable)((Object)id));
        }
        catch (MuleException e) {
            this.logger.error((Object)("Exception attempting to determine idempotency of incoming message for " + event.getFlowConstruct().getName() + " from the endpoint " + event.getMessageSourceURI()), (Throwable)e);
            return false;
        }
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }
}

